/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.Unit;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class AdminGrantComponentsCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SHouse h = null;
        String typestring = "";
        String weightstring = "";
        int comps = -1;
        int unitType = 0;
        int unitWeight = 0;
        try {
            h = (SHouse)CampaignMain.cm.getData().getHouseByName(command.nextToken());
            typestring = command.nextToken();
            weightstring = command.nextToken();
            comps = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c admingrancomponents#faction#type#weight#numcomponents", Username, true);
            return;
        }
        if (h == null) {
            CampaignMain.cm.toUser("Couldn't find a faction with that name.", Username, true);
            return;
        }
        try {
            unitType = Integer.parseInt(typestring);
        }
        catch (Exception ex) {
            unitType = Unit.getTypeIDForName(typestring);
        }
        try {
            unitWeight = Integer.parseInt(weightstring);
        }
        catch (Exception ex) {
            unitWeight = Unit.getWeightIDForName(weightstring.toUpperCase());
        }
        h.addPP(unitWeight, unitType, comps);
        CampaignMain.cm.toUser("You've granted " + comps + " Comps to " + h.getName(), Username, true);
        MMServ.mmlog.modLog(Username + " granted " + comps + " Comps to " + h.getName());
        CampaignMain.cm.doSendModMail("NOTE", Username + " granted " + comps + " Comps to " + h.getName());
    }
}

