/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.UnitFactory;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminLockFactoryCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            SPlanet p = (SPlanet)CampaignMain.cm.getData().getPlanetByName(command.nextToken());
            if (p == null) {
                CampaignMain.cm.toUser("Unknown planet!", Username, true);
                return;
            }
            UnitFactory uf = CampaignMain.cm.getData().getFactoryByName(p, command.nextToken());
            if (uf == null) {
                CampaignMain.cm.toUser("Unknown factory!", Username, true);
                return;
            }
            boolean lock = command.hasMoreElements() ? new Boolean(command.nextToken()) : !uf.isLocked();
            uf.setLock(lock);
            if (lock) {
                CampaignMain.cm.toUser("You've locked " + uf.getName() + " on planet " + p.getName(), Username, true);
                MMServ.mmlog.modLog(Username + " has locked " + uf.getName() + " on planet " + p.getName());
                CampaignMain.cm.doSendModMail("NOTE", Username + " has locked " + uf.getName() + " on planet " + p.getName());
            } else {
                uf.setTicksUntilRefresh(0);
                CampaignMain.cm.toUser("You've unlocked " + uf.getName() + " on planet " + p.getName(), Username, true);
                MMServ.mmlog.modLog(Username + " has unlocked " + uf.getName() + " on planet " + p.getName());
                CampaignMain.cm.doSendModMail("NOTE", Username + " has unlocked " + uf.getName() + " on planet " + p.getName());
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Command failed. Make sure format was: /c adminlockfactory#planetname#factoryname", Username, true);
            MMServ.mmlog.errLog(ex);
        }
    }
}

