/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AdminSaveCommandLevelsCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        TreeMap commandTable = new TreeMap(CampaignMain.cm.getServerCommands());
        try {
            File fp = new File("./data/commands");
            if (!fp.exists()) {
                fp.mkdir();
            }
            FileOutputStream out = new FileOutputStream("./data/commands/commands.dat");
            PrintStream p = new PrintStream(out);
            String commandName = "";
            Iterator i = commandTable.keySet().iterator();
            while (i.hasNext()) {
                Command commandMethod = (Command)CampaignMain.cm.getServerCommands().get(commandName);
                if (commandName != null && commandMethod != null) {
                    p.println(commandName.toUpperCase() + "#" + commandMethod.getExecutionLevel());
                }
                commandName = (String)i.next();
            }
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
            MMServ.mmlog.errLog("Unable to save command levels");
        }
        CampaignMain.cm.toUser("Command levels saved!", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has saved the command levels to file.");
    }
}

