/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.AdvanceTerrain;
import common.Continent;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;
import server.campaign.util.TimeZoneData;

public class AdminSavePlanetsToXMLCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream("./campaign/saveplanets.xml");
            PrintStream p = new PrintStream(out);
            p.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE DOCUMENT SYSTEM \"planets.dtd\">");
            p.println("<DOCUMENT>");
            p.println("<MEGAMEKNETPLANETDATA>");
            for (SPlanet planet : CampaignMain.cm.getData().getAllPlanets()) {
                p.println("\t<PLANET>");
                p.println("\t\t<NAME>" + planet.getName() + "</NAME>");
                p.println("\t\t<COMPPRODUCTION>" + planet.getCompProduction() + "</COMPPRODUCTION>");
                p.println("\t\t<XCOOD>" + planet.getPosition().x + "</XCOOD>");
                p.println("\t\t<YCOOD>" + planet.getPosition().y + "</YCOOD>");
                p.println("\t\t<INFLUENCE>");
                Iterator flu = planet.getInfluence().getHouses().iterator();
                while (flu.hasNext()) {
                    p.println("\t\t\t<INF>");
                    SHouse faction = (SHouse)flu.next();
                    p.println("\t\t\t\t<FACTION>" + faction.getName() + "</FACTION>");
                    p.println("\t\t\t\t<AMOUNT>" + planet.getInfluence().getInfluence(faction.getId()) + "</AMOUNT>");
                    p.println("\t\t\t</INF>");
                }
                p.println("\t\t</INFLUENCE>");
                Iterator UF = planet.getUnitFactories().iterator();
                while (UF.hasNext()) {
                    p.println("\t\t<UNITFACTORY>");
                    SUnitFactory factory = (SUnitFactory)UF.next();
                    p.println("\t\t\t<FACTORYNAME>" + factory.getName() + "</FACTORYNAME>");
                    p.println("\t\t\t<SIZE>" + factory.getSize() + "</SIZE>");
                    p.println("\t\t\t<FOUNDER>" + factory.getFounder() + "</FOUNDER>");
                    Enumeration TZ = factory.getTimeZones().elements();
                    while (TZ.hasMoreElements()) {
                        TimeZoneData TZData = (TimeZoneData)TZ.nextElement();
                        p.print(TZData.XMLOut());
                    }
                    if (factory.canProduce(0)) {
                        p.println("\t\t\t<TYPE>Mek</TYPE>");
                    }
                    if (factory.canProduce(2)) {
                        p.println("\t\t\t<TYPE>Infantry</TYPE>");
                    }
                    if (factory.canProduce(1)) {
                        p.println("\t\t\t<TYPE>Vehicle</TYPE>");
                    }
                    if (factory.canProduce(3)) {
                        p.println("         <TYPE>PROTOMEK</TYPE>");
                    }
                    if (factory.canProduce(4)) {
                        p.println("         <TYPE>BATTLEARMOR</TYPE>");
                    }
                    p.println("\t\t</UNITFACTORY>");
                }
                Iterator it = planet.getEnvironments().iterator();
                while (it.hasNext()) {
                    p.println("\t\t<CONTINENT>");
                    Continent pe = (Continent)it.next();
                    p.println("\t\t\t<TERRAIN>" + pe.getEnvironment().getName() + "</TERRAIN>");
                    p.println("\t\t\t<SIZE>" + pe.getSize() + "</SIZE>");
                    if (Boolean.valueOf(CampaignMain.cm.getConfig("UseStaticMaps")).booleanValue()) {
                        p.println("                 <ADVANCETERRAIN>");
                        AdvanceTerrain aTerrain = new AdvanceTerrain();
                        aTerrain = (AdvanceTerrain)planet.getAdvanceTerrain().get(new Integer(pe.getEnvironment().getId()));
                        if (aTerrain.getDisplayName().length() <= 1) {
                            p.println("                       <TERRAINNAME>" + pe.getEnvironment().getName() + "/<TERRAINNAME>");
                        } else {
                            p.println("                         <TERRAINNAME>" + aTerrain.getDisplayName() + "</TERRAINNAME>");
                        }
                        p.println("                         <XMAP>" + aTerrain.getXSize() + "</XMAP>");
                        p.println("                         <YMAP>" + aTerrain.getYSize() + "</YMAP>");
                        p.println("                         <MAP>" + aTerrain.isStaticMap() + "</MAP>");
                        p.println("                         <XBOARD>" + aTerrain.getXBoardSize() + "</XBOARD>");
                        p.println("                         <YBOARD>" + aTerrain.getYBoardSize() + "</YBOARD>");
                        p.println("                         <LOWTEMP>" + aTerrain.getLowTemp() + "</LOWTEMP>");
                        p.println("                         <HITEMP>" + aTerrain.getHighTemp() + "</HITEMP>");
                        p.println("                         <GRAVITY>" + aTerrain.getGravity() + "</GRAVITY>");
                        p.println("                         <VACUUM>" + aTerrain.isVacuum() + "</VACUUM>");
                        p.println("                         <NIGHTCHANCE>" + aTerrain.getNightChance() + "</NIGHTCHANCE>");
                        p.println("                         <NIGHTMOD>" + aTerrain.getNightTempMod() + "</NIGHTMOD>");
                        p.println("                         <MAPNAME>" + aTerrain.getStaticMapName() + "</MAPNAME>");
                        p.println("                 </ADVANCETERRAIN>");
                    }
                    p.println("\t\t</CONTINENT>");
                }
                if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseStaticMaps")).booleanValue()) {
                    p.println("\t\t<XMAP>" + planet.getMapSize().width + "</XMAP>");
                    p.println("\t\t<YMAP>" + planet.getMapSize().height + "</YMAP>");
                    p.println("\t\t<XBOARD>" + planet.getBoardSize().width + "</XBOARD>");
                    p.println("\t\t<YBOARD>" + planet.getBoardSize().height + "</YBOARD>");
                    p.println("\t\t<TEMPERATURE>");
                    p.println("\t\t\t<LOWTEMP>" + planet.getTemp().width + "</LOWTEMP>");
                    p.println("\t\t\t<HITEMP>" + planet.getTemp().height + "</HITEMP>");
                    p.println("\t\t</TEMPERATURE>");
                    p.println("\t\t<GRAVITY>" + planet.getGravity() + "</GRAVITY>");
                    p.println("\t\t<VACUUM>" + planet.isVacuum() + "</VACUUM>");
                }
                p.println("     <WAREHOUSE>" + planet.getBaysProvided() + "</WAREHOUSE>");
                p.println("\t</PLANET>");
            }
            p.println("</MEGAMEKNETPLANETDATA>");
            p.println("</DOCUMENT>");
            p.close();
            out.close();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
        CampaignMain.cm.toUser("XML saved!", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has saved the universe to XML");
    }
}

