/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.Hashtable;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AdminSetCommandLevelCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        Hashtable commandTable = CampaignMain.cm.getServerCommands();
        String commandName = command.nextToken().toUpperCase();
        int commandLevel = Integer.parseInt(command.nextToken());
        if (!commandTable.containsKey(commandName)) {
            CampaignMain.cm.toUser("Command " + commandName + " not found!", Username, true);
            return;
        }
        ((Command)commandTable.get(commandName)).setExecutionLevel(commandLevel);
        CampaignMain.cm.toUser("Command level changed on " + commandName.toLowerCase() + " to " + commandLevel, Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has changed the command level for " + commandName.toLowerCase() + " to " + commandLevel);
    }
}

