/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.awt.Dimension;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminSetPlanetBoardSizeCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet planet = (SPlanet)CampaignMain.cm.getData().getPlanetByName(command.nextToken());
        if (planet == null) {
            CampaignMain.cm.toUser("Unknown Planet", Username, true);
            return;
        }
        int x = Integer.parseInt(command.nextToken());
        int y = Integer.parseInt(command.nextToken());
        planet.setBoardSize(new Dimension(x, y));
        planet.updated();
        CampaignMain.cm.toUser("Board size set for planet " + planet.getName(), Username, true);
        MMServ.mmlog.modLog(Username + " set the board size for planet " + planet.getName());
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set the board size for planet " + planet.getName());
    }
}

