/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;

public class AdminTerminateAllCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer tp = CampaignMain.cm.getPlayer(Username);
        if (tp == null) {
            CampaignMain.cm.toUser("Null player. Report this immediately!", Username, true);
            return;
        }
        for (ShortOperation currO : CampaignMain.cm.getOpsManager().getRunningOps().values()) {
            CampaignMain.cm.getOpsManager().terminateOperation(currO, 0, tp);
        }
        MMServ.mmlog.modLog(Username + " terminated all games.");
        CampaignMain.cm.toAllUsers(Username + " has terminated all games.");
        CampaignMain.cm.doSendModMail("NOTE", Username + " has terminated all games.");
    }
}

