/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class GrantControlCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet p = null;
        SHouse from = null;
        SHouse to = null;
        try {
            p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            from = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
            to = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c grantcontrol#FromFaction#ToFaction", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("Couldn't find a planet with that name.", Username, true);
            return;
        }
        if (from == null) {
            CampaignMain.cm.toUser("Couldn't find faction which was losing control. (bad name)", Username, true);
            return;
        }
        if (to == null) {
            CampaignMain.cm.toUser("Couldn't find faction which was to gain control. (bad name)", Username, true);
            return;
        }
        int amount = Integer.parseInt(command.nextToken());
        if (p != null && from != null && to != null) {
            p.doGainInfluence(to, from, amount);
            CampaignMain.cm.addPlanet(p);
            CampaignMain.cm.toUser("Control granted", Username, true);
            MMServ.mmlog.modLog(Username + " granted control of " + amount + "% of " + p.getName() + " to " + to.getName() + ". Taken from " + from.getName() + ".");
        }
    }
}

