/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class ServerGameOptionsCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        File mmGameOptionsFolder = new File("./data/mmconf");
        if (!mmGameOptionsFolder.exists()) {
            mmGameOptionsFolder.mkdir();
        }
        File mmGameOptions = new File("./data/mmconf/gameoptions.xml");
        try {
            FileOutputStream fops = new FileOutputStream(mmGameOptions);
            PrintStream out = new PrintStream(fops);
            while (command.hasMoreTokens()) {
                out.println(command.nextToken());
            }
            out.close();
            fops.close();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Unable to save Mega Mek Game Options!");
            MMServ.mmlog.errLog(ex);
        }
        CampaignMain.cm.getMegaMekClient().game.getOptions().loadOptions("");
        CampaignMain.cm.toUser("You have set the MegaMek Game Options", Username, true);
        CampaignMain.cm.doSendModMail("MegaMek Game Options", Username + " has set the MegaMek game options for the server.");
    }
}

