/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.AdvanceTerrain;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class SetAdvancePlanetTerrainCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet planet = (SPlanet)CampaignMain.cm.getData().getPlanetByName(command.nextToken());
        if (planet == null) {
            CampaignMain.cm.toUser("Unknown Planet", Username, true);
            return;
        }
        int id = Integer.parseInt(command.nextToken());
        AdvanceTerrain aTerrain = new AdvanceTerrain();
        aTerrain = (AdvanceTerrain)planet.getAdvanceTerrain().get(new Integer(id));
        if (aTerrain == null) {
            CampaignMain.cm.toUser("Could not find that terrain planet " + planet.getName(), Username, true);
            return;
        }
        aTerrain.setDisplayName(command.nextToken());
        aTerrain.setXSize(Integer.parseInt(command.nextToken()));
        aTerrain.setYSize(Integer.parseInt(command.nextToken()));
        aTerrain.setStaticMap(new Boolean(command.nextToken()));
        aTerrain.setXBoardSize(Integer.parseInt(command.nextToken()));
        aTerrain.setYBoardSize(Integer.parseInt(command.nextToken()));
        aTerrain.setLowTemp(Integer.parseInt(command.nextToken()));
        aTerrain.setHighTemp(Integer.parseInt(command.nextToken()));
        aTerrain.setGravity(Double.parseDouble(command.nextToken()));
        aTerrain.setVacuum(new Boolean(command.nextToken()));
        aTerrain.setNightChance(Integer.parseInt(command.nextToken()));
        aTerrain.setNightTempMod(Integer.parseInt(command.nextToken()));
        aTerrain.setStaticMapName(command.nextToken());
        planet.getAdvanceTerrain().put(new Integer(id), aTerrain);
        planet.setAdvanceTerrain(planet.getAdvanceTerrain());
        planet.updated();
        CampaignMain.cm.toUser("Advance Terrain set for terrain: " + aTerrain.getDisplayName() + " on planet " + planet.getName(), Username, true);
        MMServ.mmlog.modLog(Username + " set Advance Terrain for terrain: " + aTerrain.getDisplayName() + " on planet " + planet.getName());
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set Advance Terrain for terrain: " + aTerrain.getDisplayName() + " on planet " + planet.getName());
    }
}

