/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.dataFiles.SUnitData;

public class GetPlayerUnitsCommand
implements Command {
    int accessLevel = 100;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        Command commandMethod;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String username = command.nextToken();
        String commandName = command.nextToken();
        String receivingPlayer = null;
        if (commandName.equalsIgnoreCase("admintransfer")) {
            receivingPlayer = command.nextToken();
        }
        if ((commandMethod = (Command)CampaignMain.cm.getServerCommands().get(commandName.toUpperCase())) == null) {
            CampaignMain.cm.toUser("Unknown command " + commandName + ".", Username, true);
            return;
        }
        if (commandMethod.getExecutionLevel() > userLevel) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + commandMethod.getExecutionLevel() + ".", Username, true);
            return;
        }
        SPlayer target = CampaignMain.cm.getPlayer(username);
        if (target == null) {
            CampaignMain.cm.toUser("Unknown user " + username + ".", Username, true);
            return;
        }
        String result = commandName + "|" + username + "|";
        for (SUnitData unit : target.getUnitsData()) {
            if (unit.getType() == 0 || unit.getType() == 1) {
                result = result + unit.getId() + " " + unit.getModelname() + " (" + unit.getPilot().getGunnery() + "/" + unit.getPilot().getPiloting() + ")#";
                continue;
            }
            result = result + unit.getId() + " " + unit.getModelname() + " (" + unit.getPilot().getGunnery() + ")#";
        }
        if (receivingPlayer != null) {
            result = result + "|" + receivingPlayer;
        }
        CampaignMain.cm.toUser("LPU|" + result, Username, false);
    }
}

