/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;

public class TerminateContractCommand
implements Command {
    int accessLevel = 100;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(command.nextToken());
        SHouse faction = p.getMyHouse();
        if (faction.isMercHouse()) {
            ContractInfo contract = ((MercHouse)faction).getContractInfo(p);
            if (contract != null) {
                int payment = contract.getPayment();
                SHouse employer = contract.getEmployingHouse();
                int refund = (int)((double)payment * 0.5);
                employer.setMoney(employer.getMoney() + refund);
                ((MercHouse)p.getMyHouse()).endContract(p);
                CampaignMain.cm.toUser("Your contract has been cancelled by the Review Board", p.getName(), true);
                CampaignMain.cm.toUser("You terminated " + p.getName() + "'s contract.", Username, true);
            } else {
                CampaignMain.cm.toUser(p.getName() + " has no contract to cancel", Username, true);
            }
        } else {
            CampaignMain.cm.toUser("House players do not have contracts", Username, true);
        }
    }
}

