/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.market;

import common.event.ClientEvent;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import server.MMServ;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.event.GlobalEvent;
import server.campaign.event.StatusChangeEvent;
import server.campaign.event.StatusChangeListener;
import server.campaign.event.UserEvent;
import server.campaign.market.Bid;
import server.campaign.market.MarketStatisticKeeper;
import server.campaign.market.MarketUnit;
import server.campaign.market.RemoveBidEvent;
import server.campaign.util.TimeZoneData;
import server.campaign.util.UnitHistoryKeeper;

public class Market {
    private Hashtable units = new Hashtable();
    private int newMechsSinceTick = 0;
    private transient MarketStatisticKeeper marketStatistic;
    Hashtable statusKnown = new Hashtable();
    transient EventListenerList statusChangeList = new EventListenerList();

    public Market() {
        this.marketStatistic = new MarketStatisticKeeper();
        this.ReadMarketStatistic();
        this.addStatusListener(CampaignMain.cm);
    }

    public Hashtable getAllUnits() {
        return this.units;
    }

    public void addStatusListener(StatusChangeListener l) {
        if (this.statusChangeList == null) {
            this.statusChangeList = new EventListenerList();
        }
        this.statusChangeList.add(StatusChangeListener.class, l);
    }

    public void removeStatusListener(StatusChangeListener l) {
        this.statusChangeList.remove(StatusChangeListener.class, l);
    }

    public void fireStatusEvent(String text, ClientEvent ce) {
        this.fireStatusEvent(new GlobalEvent(this, text, ce));
    }

    public void fireStatusEvent(String text, ClientEvent ce, String Username) {
        this.fireStatusEvent(new UserEvent(this, text, Username, ce));
    }

    public void fireStatusEvent(StatusChangeEvent e) {
        this.clearStatus();
    }

    public long getFreeID() {
        boolean found = false;
        long i = 0L;
        while (!found) {
            if (this.units.get(new Long(i)) == null) {
                found = true;
                continue;
            }
            ++i;
        }
        return i;
    }

    public boolean isStatusKnown(String login) {
        return this.statusKnown.containsKey(login);
    }

    public void setStatusKnown(String login) {
        this.statusKnown.put(login, new Boolean(true));
    }

    public void removeStatusKnown(String login) {
        this.statusKnown.remove(login);
    }

    public void clearStatus() {
        this.statusKnown.clear();
    }

    public void clearPlayerStatus(String username) {
        this.statusKnown.remove(username);
    }

    public Collection getStatus(String login) {
        Collection mechStatus = null;
        if (!this.isStatusKnown(login)) {
            mechStatus = this.getUnits();
            this.setStatusKnown(login);
        }
        return mechStatus;
    }

    private Collection getUnits() {
        Collection c = this.units.values();
        if (c.size() == 0) {
            return null;
        }
        return c;
    }

    public void addUnit(MarketUnit m) {
        if (m.getSeller() == null) {
            return;
        }
        if (m.getTimeLeft() > 50) {
            m.setTimeLeft(new Integer(50));
        }
        long id = this.getFreeID();
        m.setId(new Long(id));
        this.units.put(new Long(id), m);
        m.getSeller().increaseUnitsOnMarket(m.toUnit());
        ++this.newMechsSinceTick;
        if (m.getRarity() <= 5) {
            CampaignMain.cm.toAllUsers("A Rare Unit has entered the Black Market. It's a: " + m.getCmech().getSmallDescription());
        }
        this.clearStatus();
    }

    public void addBid(long id, Bid b) {
        MarketUnit m = (MarketUnit)this.units.get(new Long(id));
        if (m != null && !((Object)b.getBuyer()).equals(m.getSeller())) {
            if (m.addBid(b)) {
                CampaignMain.cm.toUser("You've bid " + CampaignMain.cm.moneyOrFluMessage(true, false, b.getAmount()) + " for the " + m.getCmech().getModelName(), b.getBuyer().getName(), true);
                if (m.getSeller().isHuman()) {
                    CampaignMain.cm.toUser(Market.getBMStatus(m.getSeller().getName(), true), m.getSeller().getName(), false);
                }
            } else {
                CampaignMain.cm.toUser("Your bid was not accepted", b.getBuyer().getName(), true);
            }
        }
    }

    public String getBidsFor(String name) {
        String result = "<font color=\"black\"> Your Bids:<br> ";
        Enumeration e = this.units.elements();
        while (e.hasMoreElements()) {
            MarketUnit m = (MarketUnit)e.nextElement();
            Bid b = m.getBidFor(name);
            if (b == null) continue;
            result = result + "You bid " + b.getAmount() + " for " + m.getCmech().getModelName() + " (ID:" + m.getId() + ")<br>";
        }
        result = result + "</font>";
        return result;
    }

    public int getNumberOfBidsFor(String name) {
        int result = 0;
        Enumeration e = this.units.elements();
        while (e.hasMoreElements()) {
            MarketUnit m = (MarketUnit)e.nextElement();
            Bid b = m.getBidFor(name);
            if (b == null) continue;
            ++result;
        }
        return result;
    }

    public int getRecallFee() {
        return 1;
    }

    public void clearMarketOfPlayers() {
        Enumeration e = this.units.elements();
        while (e.hasMoreElements()) {
            MarketUnit m = (MarketUnit)e.nextElement();
            m.getSeller().decreaseUnitsOnMarket(m.toUnit());
            m.getSeller().addUnit(m.toUnit(), false);
            this.units.remove(m.getId());
        }
    }

    public void recall(long id, SPlayer p) {
        MarketUnit m = (MarketUnit)this.units.get(new Long(id));
        if (m != null) {
            if (m.getSeller().getName().equals(p.getName())) {
                if (m.getBids().size() > 0) {
                    CampaignMain.cm.toUser("Sorry, there are already bids on that unit, you cannot recall it anymore!", p.getName(), true);
                    return;
                }
                Vector v = m.getBids();
                for (int i = 0; i < v.size(); ++i) {
                    Bid b = (Bid)v.elementAt(i);
                    CampaignMain.cm.toUser("The " + m.toUnit().getModelName() + " you bid on has been recalled from the black market.", b.getBuyer().getName(), true);
                }
                this.units.remove(new Long(id));
                p.decreaseUnitsOnMarket(m.toUnit());
                p.addUnit(m.toUnit(), false);
                p.setMoney(p.getMoney() - this.getRecallFee());
                String toReturn = "You've recalled your " + m.getCmech().getModelname() + " from the black market (-" + CampaignMain.cm.moneyOrFluMessage(true, true, this.getRecallFee()) + "";
                if (this.getRecallFee() > 1) {
                    toReturn = toReturn + "s";
                }
                toReturn = toReturn + ").";
                CampaignMain.cm.toUser(toReturn, p.getName(), true);
                this.clearStatus();
            } else {
                m.removeBid(p.getName());
                p.setMoney(p.getMoney() - this.getRecallFee());
                String toReturn = "You've cancelled your bid on the " + m.getCmech().getModelname() + " (-" + CampaignMain.cm.moneyOrFluMessage(true, true, this.getRecallFee()) + "";
                if (this.getRecallFee() > 1) {
                    toReturn = toReturn + "s";
                }
                toReturn = toReturn + ").";
                CampaignMain.cm.toUser(toReturn, p.getName(), true);
                this.fireStatusEvent("recalled bid", new RemoveBidEvent(m), p.getName());
            }
        } else {
            int mid = (int)id;
            Enumeration mUnit = this.units.elements();
            Enumeration mKey = this.units.keys();
            while (mUnit.hasMoreElements()) {
                m = (MarketUnit)mUnit.nextElement();
                Long rowKey = (Long)mKey.nextElement();
                if (m.toUnit().getId() != mid || !m.getSeller().getName().equals(p.getName())) continue;
                if (m.getBids().size() > 0) {
                    CampaignMain.cm.toUser("Sorry, there are already bids on that unit, you cannot recall it anymore!", p.getName(), true);
                    return;
                }
                Vector v = m.getBids();
                for (int i = 0; i < v.size(); ++i) {
                    Bid b = (Bid)v.elementAt(i);
                    CampaignMain.cm.toUser("The " + m.toUnit().getModelName() + " has been recalled from the market. MekBay (TM) is sorry for the inconvenience", b.getBuyer().getName(), true);
                }
                this.units.remove(rowKey);
                p.setMoney(p.getMoney() - this.getRecallFee());
                p.decreaseUnitsOnMarket(m.toUnit());
                p.addUnit(m.toUnit(), false);
                String toReturn = "You've recalled your " + m.getCmech().getModelname() + " from the black market (-" + CampaignMain.cm.moneyOrFluMessage(true, true, this.getRecallFee()) + "";
                if (this.getRecallFee() > 1) {
                    toReturn = toReturn + "s";
                }
                toReturn = toReturn + ").";
                CampaignMain.cm.toUser(toReturn, p.getName(), true);
                this.clearStatus();
                return;
            }
            CampaignMain.cm.toUser("Could not find that auction.", p.getName(), true);
        }
    }

    public String getInfo(int time) {
        String result = "<font color=\"black\">Black Market: <br>";
        Enumeration e = this.units.elements();
        while (e.hasMoreElements()) {
            MarketUnit m = (MarketUnit)e.nextElement();
            if (m.getTimeLeft() > time && time != 0) continue;
            result = result + m.getInfo(this.marketStatistic.getAverageForMech(m.toUnit()));
        }
        result = result + "</font>";
        return result;
    }

    public int getNewUnitsSinceTick() {
        return this.newMechsSinceTick;
    }

    public void tick() {
        this.newMechsSinceTick = 0;
        Enumeration e = this.units.elements();
        while (e.hasMoreElements()) {
            MarketUnit m = (MarketUnit)e.nextElement();
            if (m.isAuctionFinished()) {
                SUnit cm;
                boolean abletobuy = false;
                Bid b = m.getWinningBid();
                while (!abletobuy && b != null) {
                    if (b.getBuyer() != null) {
                        if (b.getBuyer().getMoney() < b.getAmount()) {
                            CampaignMain.cm.toUser("You couldn't buy the " + m.getCmech().getModelName() + " since you couldn't afford the " + CampaignMain.cm.moneyOrFluMessage(true, true, b.getAmount()) + " you bid.", b.getBuyer().getName(), true);
                        } else {
                            abletobuy = true;
                        }
                    }
                    if (abletobuy) continue;
                    m.removeBid(b);
                    b = m.getWinningBid();
                }
                if (b != null) {
                    cm = m.toUnit();
                    this.marketStatistic.addTransfer(b.getAmount(), cm);
                    UnitHistoryKeeper.addSoldOnBMEntry(cm.getId(), b.getBuyer().getName(), b.getBuyer().getHouseName(), m.getSeller().getName(), m.getSeller().getHouseName());
                    b.getBuyer().setMoney(b.getBuyer().getMoney() - b.getAmount());
                    int market_share = 0;
                    try {
                        int mod = ((SPlayer)m.getSeller()).getExperience() / 150;
                        int roll = 0;
                        roll = mod >= 10 ? CampaignMain.cm.getR().nextInt(5) + 5 : CampaignMain.cm.getR().nextInt(mod) + CampaignMain.cm.getR().nextInt(6) + 2 - mod;
                        double percent = (double)Math.max(roll, 0) * 0.05;
                        market_share = (int)Math.round(percent * (double)b.getAmount()) + (int)Math.ceil((double)b.getAmount() * 0.01);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    this.units.remove(m.getId());
                    m.getSeller().decreaseUnitsOnMarket(m.toUnit());
                    m.getSeller().addMoney(b.getAmount() - market_share);
                    b.getBuyer().addUnit(cm, true);
                    CampaignMain.cm.toUser("You've sold the " + m.getCmech().getModelName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, b.getAmount()) + "<br>" + (market_share == 0 ? "" : "Your contacts took " + market_share + " " + CampaignMain.cm.moneyOrFluMessage(true, true, market_share) + " for themselves"), m.getSeller().getName(), true);
                    CampaignMain.cm.toUser("You've bought the " + m.getCmech().getModelName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, b.getAmount()) + "<br>", b.getBuyer().getName(), true);
                    CampaignMain.cm.toUser("PL|BMW|1", b.getBuyer().getName(), false);
                    MMServ.mmlog.bmLog(b.getBuyer().getName() + " bought a " + m.getCmech().getModelName() + " for " + b.getAmount());
                    Vector bids = m.getBids();
                    for (int i = 0; i < bids.size(); ++i) {
                        Bid bid = (Bid)bids.elementAt(i);
                        if (bid == b) continue;
                        CampaignMain.cm.toUser("You didn't get the  " + m.getCmech().getModelName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, bid.getAmount()) + ". The highest bid was: " + CampaignMain.cm.moneyOrFluMessage(true, true, b.getAmount()) + "<br>", bid.getBuyer().getName(), true);
                    }
                    continue;
                }
                CampaignMain.cm.toUser("No one wanted to buy the " + m.getCmech().getModelName() + ". It has been returned to your hangar", m.getSeller().getName(), true);
                cm = m.toUnit();
                m.getSeller().decreaseUnitsOnMarket(m.toUnit());
                m.getSeller().addUnit(cm, false);
                if (this.marketStatistic.getAverageForMech(m.getCmech()) > m.getMinBid()) {
                    this.marketStatistic.addTransfer(1, cm);
                }
                this.units.remove(m.getId());
                continue;
            }
            m.tick();
        }
        int losTech = CampaignMain.cm.getR().nextInt(100);
        if (losTech < Integer.parseInt(CampaignMain.cm.getConfig("RareChance"))) {
            int pickReason;
            int size = CampaignMain.cm.getR().nextInt(4);
            String faction = "Rare";
            SHouse seller = CampaignMain.cm.getHouseFromPartialString(CampaignMain.cm.getConfig("NewbieHouseName"), null);
            String Filename = BuildTable.getUnitFilename(faction, SUnit.getWeightClassDesc(size), 0, new TimeZoneData("3025", 100));
            String[] reasons = new String[]{"Brewed by aliens and delivered to our planetoid", "Hidden in a cache for centuries", "From an unknown source", "Built by " + seller.getName() + " in a hidden facility"};
            String reason = reasons[pickReason = CampaignMain.cm.getR().nextInt(4)];
            SUnit mech = new SUnit(reason, Filename, size);
            int price = this.marketStatistic.getAverageForMech(mech);
            price = price == 0 ? seller.getPriceForUnit(mech.getWeightclass(), mech.getType(), null) : (int)((double)price * 0.75);
            MarketUnit newMech = new MarketUnit(seller, 20, price, "Sold by mysterious figures", mech);
            newMech.setRarity(1);
            this.addUnit(newMech);
        }
        this.clearStatus();
    }

    public void ReadMarketStatistic() {
        if (CampaignMain.cm.useHibernate()) {
            this.marketStatistic = new MarketStatisticKeeper();
        } else {
            try {
                FileInputStream fis = new FileInputStream("./campaign/marketstats.dat");
                ObjectInputStream p = new ObjectInputStream(fis);
                this.marketStatistic = (MarketStatisticKeeper)p.readObject();
                p.close();
                fis.close();
            }
            catch (Exception ex) {
                this.marketStatistic = new MarketStatisticKeeper();
            }
        }
    }

    public void WriteMarketStatistic() {
    }

    public MarketStatisticKeeper getMarketStatistic() {
        return this.marketStatistic;
    }

    public static synchronized String getBMStatus(String Username, boolean toPlayer) {
        StringBuffer result = new StringBuffer();
        Collection mechs = CampaignMain.cm.getMarket().getStatus(Username);
        if (mechs != null) {
            result.append("BM|DA|" + mechs.size() + "|");
            for (MarketUnit mm : mechs) {
                result.append(mm.toString(Username, toPlayer));
                result.append("|");
            }
        }
        return result.toString();
    }
}

