/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.market;

import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SUnit;
import server.campaign.market.Bid;
import server.campaign.market.MarketSeller;

public class MarketUnit {
    private MarketSeller seller;
    private Vector bids = new Vector();
    private Integer timeLeft;
    private String comment = "";
    private Integer minBid = new Integer(0);
    private Long id = new Long(-1L);
    private SUnit cmech;
    private int rarity = 100;

    public MarketUnit() {
    }

    public MarketUnit(MarketSeller seller, int timeleft, int minbid, String comment, SUnit cmech) {
        this.cmech = cmech;
        this.seller = seller;
        this.timeLeft = new Integer(timeleft);
        this.minBid = new Integer(minbid);
        this.comment = comment;
    }

    public SUnit toUnit() {
        return this.cmech;
    }

    public String toString(String Playername, boolean toPlayer) {
        String delimiter = "*";
        String result = "MM";
        result = result + delimiter;
        result = result + this.id;
        result = result + delimiter;
        result = result + this.cmech.toString(toPlayer);
        result = result + delimiter;
        result = !this.comment.equals("") ? result + this.comment : result + " ";
        result = result + delimiter;
        result = result + this.timeLeft;
        result = result + delimiter;
        result = result + this.minBid;
        result = result + delimiter;
        result = Playername.equals(this.seller.getName()) || Playername.equals("") ? result + this.seller.getName() : result + "unknown";
        if (Playername.equals("")) {
            result = result + delimiter;
            result = result + this.bids.size();
            for (int i = 0; i < this.bids.size(); ++i) {
                result = result + delimiter;
                result = result + ((Bid)this.bids.elementAt(i)).toString();
            }
        } else {
            Bid b = this.getBidFor(Playername);
            result = result + delimiter;
            result = b == null ? result + "0" : result + "1" + delimiter + b.getAmount();
            result = result + delimiter;
            result = result + CampaignMain.cm.getMarket().getMarketStatistic().getAverageForMech(this.cmech);
            result = result + delimiter;
            result = result + this.cmech.getBV();
        }
        return result;
    }

    public void fromString(String s, CampaignMain myC) {
        s = s.substring(3);
        StringTokenizer ST = new StringTokenizer(s, "*");
        this.id = new Long((String)ST.nextElement());
        this.cmech = new SUnit();
        this.cmech.fromString(ST.nextToken());
        this.comment = ST.nextToken();
        this.timeLeft = new Integer(ST.nextToken());
        this.minBid = new Integer(ST.nextToken());
        String sellername = ST.nextToken();
        SHouse h = null;
        h = this.id == 0L ? CampaignMain.cm.getHouseFromPartialString(CampaignMain.cm.getConfig("NewbieHouseName"), null) : CampaignMain.cm.getHouseFromPartialString(sellername, null);
        this.seller = h != null ? h : myC.getPlayer(sellername);
        int bidsamount = new Integer(ST.nextToken());
        for (int i = 0; i < bidsamount; ++i) {
            String bidstring = ST.nextToken();
            Bid bid = new Bid();
            bid.fromString(bidstring, myC);
            this.addBid(bid);
        }
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public boolean addBid(Bid b) {
        if (b.getAmount() >= this.minBid) {
            boolean found = false;
            for (int i = 0; i < this.bids.size(); ++i) {
                Bid bid = (Bid)this.bids.elementAt(i);
                if (!((Object)bid.getBuyer()).equals(b.getBuyer())) continue;
                this.bids.setElementAt(b, i);
                found = true;
            }
            if (!found) {
                this.bids.add(b);
            }
            return true;
        }
        return false;
    }

    public Vector getBids() {
        return this.bids;
    }

    public Integer getTimeLeft() {
        return this.timeLeft;
    }

    public Bid getBidFor(String Buyer) {
        for (int i = 0; i < this.bids.size(); ++i) {
            if (!((Bid)this.bids.elementAt(i)).getBuyer().getName().equals(Buyer)) continue;
            return (Bid)this.bids.elementAt(i);
        }
        return null;
    }

    public Bid getWinningBid() {
        Bid b = null;
        for (int i = 0; i < this.bids.size(); ++i) {
            Bid curBid = (Bid)this.bids.elementAt(i);
            if (b == null) {
                b = curBid;
                continue;
            }
            if (curBid.getAmount() <= b.getAmount()) continue;
            b = curBid;
        }
        return b;
    }

    public void removeBid(Bid b) {
        this.bids.remove(b);
    }

    public void removeBid(String user) {
        for (int i = 0; i < this.bids.size(); ++i) {
            if (!((Bid)this.bids.elementAt(i)).getBuyer().getName().equals(user)) continue;
            this.removeBid((Bid)this.bids.elementAt(i));
        }
    }

    public String getInfo(int averageprice) {
        String result = "";
        result = result + "#" + this.getId();
        result = this.cmech.getType() == 0 || this.cmech.getType() == 1 ? result + " " + this.cmech.getModelName() + " [" + this.cmech.getPilot().getGunnery() + "/" + this.cmech.getPilot().getPiloting() + "]" : result + " " + this.cmech.getModelName() + " [" + this.cmech.getPilot().getGunnery() + "]";
        result = result + ". Minimum Bid: " + this.getMinBid() + " (AV:" + averageprice + "). Remaining Ticks: " + this.getTimeLeft();
        if (this.getComment() != "") {
            result = result + " Comment: " + this.getComment();
        }
        result = result + "<br>";
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    public void tick() {
        if (this.timeLeft > 0) {
            this.setTimeLeft(new Integer(this.timeLeft - 1));
        }
    }

    public boolean isAuctionFinished() {
        return this.timeLeft == 0;
    }

    public Integer getMinBid() {
        return this.minBid;
    }

    public MarketSeller getSeller() {
        return this.seller;
    }

    public SUnit getCmech() {
        return this.cmech;
    }

    public int getRarity() {
        return this.rarity;
    }

    public void setCmech(SUnit cmech) {
        this.cmech = cmech;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setMinBid(Integer minBid) {
        this.minBid = minBid;
    }

    public void setSeller(MarketSeller seller) {
        this.seller = seller;
    }

    public void setTimeLeft(Integer timeleft) {
        this.timeLeft = timeleft;
    }

    public void setRarity(int rare) {
        this.rarity = rare;
    }
}

