/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.mercenaries;

import java.io.Serializable;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;

public class ContractInfo
implements Serializable {
    private int _contractDuration;
    private int _startingExperience;
    private int _payment;
    private String _contractingHouse;
    private String _playerName;
    private String _offeringPlayer;

    public ContractInfo(int duration, int startXP, int payment, SHouse contractHouse, String name) {
        this._contractDuration = duration;
        this._startingExperience = startXP;
        this._payment = payment;
        this._contractingHouse = contractHouse.getName();
        this._playerName = name;
    }

    public int getContractDuration() {
        return this._contractDuration;
    }

    public int getStartingExperience() {
        return this._startingExperience;
    }

    public SHouse getEmployingHouse() {
        return CampaignMain.cm.getHouseFromPartialString(this._contractingHouse, null);
    }

    public String getPlayerName() {
        return this._playerName;
    }

    public int getPayment() {
        return this._payment;
    }

    public SPlayer getOfferingPlayer() {
        return CampaignMain.cm.getPlayer(this._offeringPlayer);
    }

    public void setOfferingPlayer(SPlayer p) {
        this._offeringPlayer = p.getName();
    }

    public boolean isLegal() {
        if (CampaignMain.cm.getHouseFromPartialString(this._contractingHouse, null) == null) {
            return false;
        }
        if (CampaignMain.cm.getPlayer(this._offeringPlayer) == null) {
            return false;
        }
        return CampaignMain.cm.getPlayer(this._playerName) != null;
    }

    public String toString() {
        String result = "CON$";
        result = result + this._contractDuration;
        result = result + "$";
        result = result + this._startingExperience;
        result = result + "$";
        result = result + this._payment;
        result = result + "$";
        result = result + this._contractingHouse;
        result = result + "$";
        result = result + this._playerName;
        result = result + "$";
        result = result + this._offeringPlayer;
        return result;
    }

    public void fromString(String s) {
        s = s.substring(4);
        StringTokenizer ST = new StringTokenizer(s, "$");
        this._contractDuration = Integer.parseInt(ST.nextToken());
        this._startingExperience = Integer.parseInt((String)ST.nextElement());
        this._payment = Integer.parseInt((String)ST.nextElement());
        this._contractingHouse = ST.nextToken();
        this._playerName = ST.nextToken();
        this._offeringPlayer = ST.nextToken();
    }

    public ContractInfo() {
    }
}

