/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import java.util.ArrayList;
import java.util.Iterator;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;

public class LongValidator {
    private OperationManager manager;
    public static final int LFAILS_UNAUTHORIZED = 0;
    public static final int LFAILS_ALREADYTARGETTED = 1;
    public static final int LFAILS_HOUSEMAXED = 2;
    public static final int LFAILS_RANGE = 101;
    public static final int LFAILS_HOUSEMONEY = 102;
    public static final int LFAILS_HOUSEACTIONS = 103;
    public static final int LFAILS_PLAYERMONEY = 104;
    public static final int LFAILS_PLAYERREWARD = 105;
    public static final int LFAILS_PLAYERFLU = 106;
    public static final int LFAILS_PLAYEREXP = 107;

    public LongValidator(OperationManager m) {
        this.manager = m;
    }

    public ArrayList validateLongOp(SPlayer p, SHouse ah, SPlanet pl, Operation o) {
        ArrayList<Integer> failList = new ArrayList<Integer>();
        if (this.manager.hasLongOnPlanet(ah, pl)) {
            failList.add(new Integer(1));
            return failList;
        }
        int requiredMoney = Integer.parseInt(o.getValue("LHouseLaunchMoney"));
        int requiredActions = Integer.parseInt(o.getValue("LHouseLaunchActions"));
        int reqPlayerMoney = Integer.parseInt(o.getValue("LPlayerLaunchMoney"));
        int reqPlayerRP = Integer.parseInt(o.getValue("LPlayerLaunchReward"));
        int reqPlayerFlu = Integer.parseInt(o.getValue("LPlayerLaunchFlu"));
        int reqPlayerXP = Integer.parseInt(o.getValue("LPlayerLaunchExp"));
        if (requiredMoney > ah.getMoney()) {
            failList.add(new Integer(102));
        }
        if (reqPlayerMoney > p.getMoney()) {
            failList.add(new Integer(104));
        }
        if (reqPlayerFlu > p.getInfluence()) {
            failList.add(new Integer(106));
        }
        if (reqPlayerRP > p.getReward()) {
            failList.add(new Integer(105));
        }
        if (reqPlayerXP > p.getExperience()) {
            failList.add(new Integer(107));
        }
        return failList;
    }

    public String failuresToString(ArrayList failList) {
        String s = "Launch failed ";
        if (failList == null) {
            s = s + " for reasons unknown ...";
            return s;
        }
        if (failList.size() == 1) {
            s = s + " because " + this.decodeFailure((Integer)failList.get(0)) + ".";
            return s;
        }
        s = s + "because:<br>";
        Iterator i = failList.iterator();
        while (i.hasNext()) {
            s = s + "- " + this.decodeFailure((Integer)i.next());
            if (!i.hasNext()) continue;
            s = s + "<br>";
        }
        return "";
    }

    private String decodeFailure(Integer code) {
        int decoded = code;
        switch (decoded) {
            case 1: {
                return "the target planet is already under attack";
            }
            case 103: {
                return "your faction has too few actions remaining";
            }
            case 2: {
                return "your faction has too many running operations";
            }
            case 102: {
                return "your faction has insufficient funds";
            }
            case 107: {
                return "you do not have enough experience";
            }
            case 106: {
                return "you do not have enough influence";
            }
            case 104: {
                return "your funds are insufficient";
            }
            case 105: {
                return "you do not have enough RP";
            }
            case 101: {
                return "the target planet is out of range";
            }
            case 0: {
                return "you are not able to initiate assaults";
            }
        }
        return "for reasons unknown ... (report error to admin/operator!)";
    }
}

