/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import java.util.ArrayList;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.operations.Operation;
import server.campaign.operations.ShortOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpsChickenThread
extends Thread {
    private SPlayer pdefender;
    private Vector<SArmy> parmies;
    private int opID;
    private String opName;
    private String message;
    private boolean shouldContinue;
    private int waittime;
    private int leechCount;

    public OpsChickenThread(SPlayer pd, int id, String name, String mess) {
        this.pdefender = pd;
        this.parmies = new Vector();
        this.shouldContinue = true;
        this.leechCount = 0;
        this.message = mess;
        this.opID = id;
        this.opName = name;
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        this.waittime = Integer.parseInt(o.getValue("TimeToNondefensePenalty"));
    }

    public void addArmy(SArmy a) {
        this.parmies.add(a);
    }

    public Vector<SArmy> getArmies() {
        return this.parmies;
    }

    public void stopChicken() {
        this.shouldContinue = false;
    }

    public void doPenalty() {
        int actualPenalty;
        if (this.pdefender.getMyHouse().isNewbieHouse()) {
            String toPlayer = "You did not defend Attack #" + this.opID + ". You're not been punished because " + "you are in the training faction; however, if you leave an attack undefended in a normal " + "faction you may lose money, units, experience, influence, rewards, or some combination thereof.";
            CampaignMain.cm.toUser(toPlayer, this.pdefender.getName(), true);
            return;
        }
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        double rpPercent = Double.parseDouble(o.getValue("PercentRPChickenPenalty"));
        double expPercent = Double.parseDouble(o.getValue("PercentExpChickenPenalty"));
        double fluPrecent = Double.parseDouble(o.getValue("PercentInfluenceChickenPenalty"));
        double moneyPercent = Double.parseDouble(o.getValue("PercentCBillChickenPenalty"));
        int rpFlat = Integer.parseInt(o.getValue("FlatRPChickenPenalty"));
        int expFlat = Integer.parseInt(o.getValue("FlatExpChickenPenalty"));
        int fluFlat = Integer.parseInt(o.getValue("FlatInfluenceChickenPenalty"));
        int moneyFlat = Integer.parseInt(o.getValue("FlatCBillChickenPenalty"));
        int totalRPLoss = 0;
        int totalEXPLoss = 0;
        int totalFluLoss = 0;
        int totalMoneyLoss = 0;
        if (rpPercent > 0.0) {
            totalRPLoss = (int)((double)this.pdefender.getReward() * rpPercent);
        }
        if (expPercent > 0.0) {
            totalEXPLoss = (int)((double)this.pdefender.getReward() * expPercent);
        }
        if (fluPrecent > 0.0) {
            totalFluLoss = (int)((double)this.pdefender.getReward() * fluPrecent);
        }
        if (moneyPercent > 0.0) {
            totalMoneyLoss = (int)((double)this.pdefender.getReward() * moneyPercent);
        }
        if (rpFlat > 0) {
            totalRPLoss += rpFlat;
        }
        if (rpFlat > 0) {
            totalEXPLoss += expFlat;
        }
        if (rpFlat > 0) {
            totalFluLoss += fluFlat;
        }
        if (rpFlat > 0) {
            totalMoneyLoss += moneyFlat;
        }
        if (totalRPLoss > this.pdefender.getReward()) {
            totalRPLoss = this.pdefender.getReward();
        }
        if (totalEXPLoss > this.pdefender.getExperience()) {
            totalEXPLoss = this.pdefender.getExperience();
        }
        if (totalFluLoss > this.pdefender.getInfluence()) {
            totalFluLoss = this.pdefender.getInfluence();
        }
        if (totalMoneyLoss > this.pdefender.getMoney()) {
            totalMoneyLoss = this.pdefender.getMoney();
        }
        boolean hasLoss = false;
        String toPlayer = "Attack #" + this.opID + " wasn't defended in time!";
        if (totalRPLoss > 0) {
            toPlayer = !hasLoss ? toPlayer + " (-" + totalRPLoss + " RP" : toPlayer + ", -" + totalRPLoss + " RP";
            this.pdefender.addReward(-totalRPLoss);
            hasLoss = true;
        }
        if (totalEXPLoss > 0) {
            toPlayer = !hasLoss ? toPlayer + " (-" + totalEXPLoss + " XP" : toPlayer + ", -" + totalEXPLoss + " XP";
            this.pdefender.addExperience(-totalEXPLoss);
            hasLoss = true;
        }
        if (totalFluLoss > 0) {
            toPlayer = !hasLoss ? toPlayer + " (-" + CampaignMain.cm.moneyOrFluMessage(false, true, totalFluLoss) : toPlayer + ", -" + CampaignMain.cm.moneyOrFluMessage(false, true, totalFluLoss);
            this.pdefender.addInfluence(-totalFluLoss);
            hasLoss = true;
        }
        if (totalMoneyLoss > 0) {
            toPlayer = !hasLoss ? toPlayer + " (-" + CampaignMain.cm.moneyOrFluMessage(true, true, totalMoneyLoss) : toPlayer + ", -" + CampaignMain.cm.moneyOrFluMessage(true, true, totalMoneyLoss);
            this.pdefender.addMoney(-totalMoneyLoss);
            hasLoss = true;
        }
        if (hasLoss) {
            toPlayer = toPlayer + ")";
        }
        CampaignMain.cm.toUser(toPlayer, this.pdefender.getName(), true);
        ShortOperation parentOp = CampaignMain.cm.getOpsManager().getRunningOps().get(this.opID);
        if (parentOp == null) {
            MMServ.mmlog.errLog("Tried to do a leech with a null ShortOperation!");
            return;
        }
        int conquestPenalty = Integer.parseInt(o.getValue("ConquestPerLeech"));
        int delayPenalty = Integer.parseInt(o.getValue("DelayPerLeech"));
        int prodPenalty = Integer.parseInt(o.getValue("ProdPointsPerLeech"));
        int unitPenalty = Integer.parseInt(o.getValue("UnitsPerLeech"));
        int rolloverPenalty = Integer.parseInt(o.getValue("FailurePenalty"));
        String toMain = this.pdefender.getColoredName() + " did not defend Attack #" + this.opID + " in time! " + this.pdefender.getHouseFightingFor().getColoredNameAsLink() + " has lost ";
        String firstKey = parentOp.getAttackers().firstKey();
        SHouse attackH = CampaignMain.cm.getPlayer(firstKey).getHouseFightingFor();
        SHouse defendH = this.pdefender.getHouseFightingFor();
        SPlanet target = parentOp.getTargetWorld();
        if (!attackH.isConquerable() || !defendH.isConquerable()) {
            conquestPenalty = 0;
        }
        if (!target.isConquerable()) {
            conquestPenalty = 0;
        }
        hasLoss = false;
        if (conquestPenalty > 0 && (actualPenalty = target.doGainInfluence(attackH, defendH, conquestPenalty)) > 0) {
            toMain = toMain + actualPenalty + "% of " + target.getNameAsColoredLink();
            hasLoss = true;
        }
        if (delayPenalty > 0) {
            if (target.getFactoryCount() == 0) {
                return;
            }
            if (!target.getOwner().equals(defendH)) {
                return;
            }
            for (SUnitFactory currFac : target.getUnitFactories()) {
                currFac.addRefresh(delayPenalty);
            }
            if (hasLoss) {
                toMain = toMain + ", production on " + target.getNameAsColoredLink() + " for " + delayPenalty + " miniticks";
            } else {
                toMain = toMain + " production on " + target.getNameAsColoredLink() + " for " + delayPenalty + " miniticks";
                hasLoss = true;
            }
        }
        if (unitPenalty > 0) {
            ArrayList<SUnit> capturedUnits = new ArrayList<SUnit>();
            int numCaptured = 0;
            for (int type = 0; type <= 4; ++type) {
                for (int weight = 3; weight >= 0; --weight) {
                    boolean noUnits = false;
                    while (!noUnits && numCaptured < unitPenalty) {
                        SUnit captured = defendH.getEntity(weight, type);
                        if (captured == null) {
                            noUnits = true;
                            continue;
                        }
                        capturedUnits.add(captured);
                        attackH.addUnit(captured, true);
                        ++numCaptured;
                    }
                }
            }
            if (numCaptured > 0) {
                String unitString = "";
                for (SUnit currU : capturedUnits) {
                    unitString = unitString + currU.getModelName() + ", ";
                }
                unitString = unitString.substring(0, unitString.length() - 2);
                if (hasLoss) {
                    toMain = numCaptured == 1 ? toMain + ", a unit [" + unitString + "]" : toMain + ", " + numCaptured + " units [" + unitString + "]";
                } else {
                    hasLoss = true;
                    toMain = numCaptured == 1 ? toMain + " a unit [" + unitString + "]" : toMain + " " + numCaptured + " units [" + unitString + "]";
                }
            }
        }
        if (prodPenalty > 0 || !hasLoss && rolloverPenalty > 0) {
            if (prodPenalty <= 0) {
                prodPenalty = rolloverPenalty;
            }
            boolean foundComponents = false;
            for (int type = 3; type >= 0 && !foundComponents; --type) {
                if (defendH.getPP(type, 0) <= 0) continue;
                int actualPP = defendH.getPP(type, 0);
                if (actualPP < prodPenalty) {
                    prodPenalty = actualPP;
                }
                defendH.addPP(type, 0, -prodPenalty);
                attackH.addPP(type, 0, prodPenalty);
                if (hasLoss) {
                    toMain = toMain + ", " + prodPenalty + " " + SUnit.getWeightClassDesc(type) + " Mek components";
                } else {
                    toMain = toMain + " " + prodPenalty + " " + SUnit.getWeightClassDesc(type) + " Mek components";
                    hasLoss = true;
                }
                foundComponents = true;
            }
        }
        if (hasLoss) {
            CampaignMain.cm.toAllUsers(toMain);
        }
    }

    @Override
    public synchronized void run() {
        boolean hasAnArmy = false;
        String toSend = this.message + "<br>You may defend with: ";
        for (SArmy currArmy : this.parmies) {
            int aID = currArmy.getID();
            int aBV = currArmy.getOperationsBV(null);
            int aUnits = currArmy.getAmountOfUnits();
            if (hasAnArmy) {
                toSend = toSend + ", ";
            }
            toSend = toSend + "<a href=\"MEKWARS/c defend#" + this.opID + "#" + aID + "\">Army #" + aID + "</a> (Units: " + aUnits + " / BV: " + aBV + ")";
            hasAnArmy = true;
        }
        CampaignMain.cm.toUser(toSend, this.pdefender.getName(), true);
        CampaignMain.cm.toUser("CC|AT", this.pdefender.getName(), false);
        this.message = null;
        while (true) {
            try {
                this.wait(this.waittime * 1000);
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog(ex);
            }
            if (!this.shouldContinue) {
                return;
            }
            ++this.leechCount;
            if (this.leechCount >= Integer.parseInt(CampaignMain.cm.getOpsManager().getOperation(this.opName).getValue("LeechesToDeactivate"))) {
                SPlayer currP = CampaignMain.cm.getPlayer(this.pdefender.getName());
                currP.setActive(false);
                CampaignMain.cm.sendPlayerStatusUpdate(currP, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
                CampaignMain.cm.toUser("You've been deactivated!", currP.getName(), true);
                return;
            }
            this.doPenalty();
        }
    }
}

