/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.operations.Operation;
import server.campaign.operations.ShortOperation;

public class OpsDisconnectionThread
extends Thread {
    private boolean playerReturned = false;
    private int id;
    private String winnerName;
    private String loserName;
    private long waitReduction;

    public OpsDisconnectionThread(int opID, String w, String l, long waitReduction) {
        this.winnerName = w;
        this.loserName = l;
        this.id = opID;
        this.waitReduction = waitReduction;
    }

    public synchronized void run() {
        long timeToReport = Long.parseLong(CampaignMain.cm.getConfig("DisconnectionTimeToReport"));
        if ((timeToReport -= this.waitReduction) < 120L) {
            timeToReport = 120L;
        }
        CampaignMain.cm.toUser(CampaignMain.cm.getPlayer(this.loserName).getColoredName() + " disconnected. If he does not return within " + CampaignMain.readableTimeWithSeconds(timeToReport *= 1000L) + "you will win by default.", this.winnerName, true);
        try {
            this.wait(timeToReport);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
        if (this.playerReturned) {
            return;
        }
        ShortOperation so = CampaignMain.cm.getOpsManager().getRunningOps().get(this.id);
        if (so == null) {
            return;
        }
        Operation o = CampaignMain.cm.getOpsManager().getOperation(so.getName());
        SPlayer winner = CampaignMain.cm.getPlayer(this.winnerName);
        SPlayer loser = CampaignMain.cm.getPlayer(this.loserName);
        CampaignMain.cm.getOpsManager().resolveShortAttack(o, so, winner, loser);
    }

    public void playerReturned(boolean tellOtherPlayer) {
        if (tellOtherPlayer) {
            CampaignMain.cm.toUser(CampaignMain.cm.getPlayer(this.loserName).getColoredName() + " returned.", this.winnerName, true);
        }
        this.playerReturned = true;
    }

    public int getShortID() {
        return this.id;
    }

    public boolean playerHasReturned() {
        return this.playerReturned;
    }
}

