/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.pilot.skills.SPilotSkill;

public class GunneryBallisticSkill
extends SPilotSkill {
    public GunneryBallisticSkill(int id) {
        super(id, "Gunnery/Ballistic", "GB");
    }

    public GunneryBallisticSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        return Integer.parseInt(CampaignMain.cm.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("gunnery_ballistic", true));
    }

    public int getBVMod(Entity unit) {
        int numberOfBallista = 0;
        int gunneryBallisticBVBaseMod = Integer.parseInt(CampaignMain.cm.getConfig("GunneryBallisticBaseBVMod"));
        Enumeration weaponsList = unit.getWeapons();
        while (weaponsList.hasMoreElements()) {
            Mounted weapon = (Mounted)weaponsList.nextElement();
            if (!weapon.getType().hasFlag(131072)) continue;
            ++numberOfBallista;
        }
        return numberOfBallista * gunneryBallisticBVBaseMod;
    }
}

