/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.pilot.skills.SPilotSkill;

public class GunneryLaserSkill
extends SPilotSkill {
    public GunneryLaserSkill(int id) {
        super(id, "Gunnery/Laser", "GL");
    }

    public GunneryLaserSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        return Integer.parseInt(CampaignMain.cm.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("gunnery_laser", true));
    }

    public int getBVMod(Entity unit) {
        int numberOfLasers = 0;
        int gunneryLaserBVBaseMod = Integer.parseInt(CampaignMain.cm.getConfig("GunneryLaserBaseBVMod"));
        Enumeration weaponsList = unit.getWeapons();
        while (weaponsList.hasMoreElements()) {
            Mounted weapon = (Mounted)weaponsList.nextElement();
            if (!weapon.getType().hasFlag(262144)) continue;
            ++numberOfLasers;
        }
        return numberOfLasers * gunneryLaserBVBaseMod;
    }
}

