/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.pilot.skills.SPilotSkill;

public class GunneryMissileSkill
extends SPilotSkill {
    public GunneryMissileSkill(int id) {
        super(id, "Gunnery/Missile", "GM");
    }

    public GunneryMissileSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        return Integer.parseInt(CampaignMain.cm.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("gunnery_missile", true));
    }

    public int getBVMod(Entity unit) {
        int numberOfMissles = 0;
        int gunneryMissleBVBaseMod = Integer.parseInt(CampaignMain.cm.getConfig("GunneryMissileBaseBVMod"));
        Enumeration weaponsList = unit.getWeapons();
        while (weaponsList.hasMoreElements()) {
            Mounted weapon = (Mounted)weaponsList.nextElement();
            if (!weapon.getType().hasFlag(524288)) continue;
            ++numberOfMissles;
        }
        return numberOfMissles * gunneryMissleBVBaseMod;
    }
}

