/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import java.util.Enumeration;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.SPilotSkill;

public class IronManSkill
extends SPilotSkill {
    public IronManSkill(int id) {
        super(id, "Iron Man", "IM");
    }

    public IronManSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        if (unitType != 0) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        return Integer.parseInt(CampaignMain.cm.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("iron_man", true));
    }

    public int getBVMod(Entity unit) {
        return 0;
    }

    public int getBVMod(Entity unit, SPilot pilot) {
        int amountOfAmmo = 0;
        int IronManBVBaseMod = Integer.parseInt(CampaignMain.cm.getConfig("IronManBaseBVMod"));
        if (pilot.getSkills().has(4)) {
            return 0;
        }
        Enumeration ammoList = unit.getAmmo();
        while (ammoList.hasMoreElements()) {
            Mounted ammoType = (Mounted)ammoList.nextElement();
            AmmoType ammo = (AmmoType)ammoType.getType();
            if (ammo.getAmmoType() == 6 || ammo.getAmmoType() == 22 || ammo.getAmmoType() == 21) continue;
            ++amountOfAmmo;
        }
        Enumeration weaponsList = unit.getWeapons();
        while (weaponsList.hasMoreElements()) {
            Mounted weapon = (Mounted)weaponsList.nextElement();
            if (weapon.getName().indexOf("Gauss Rifle") == -1) continue;
            ++amountOfAmmo;
        }
        return amountOfAmmo * IronManBVBaseMod;
    }
}

