/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.campaign.pilot.Pilot;
import server.campaign.pilot.skills.SPilotSkill;

public abstract class SLevelPilotSkill
extends SPilotSkill {
    private SLevelPilotSkill previous;
    private int level = 1;

    protected abstract int getUpgradeChance(int var1, int var2, Pilot var3);

    public int getLevel() {
        return this.level;
    }

    public SLevelPilotSkill(int id, String name, SLevelPilotSkill previous, String abbreviation) {
        super(id, name, abbreviation);
        this.previous = previous;
        SLevelPilotSkill p = previous;
        while (p != null) {
            ++this.level;
            p = p.previous;
        }
    }

    public SLevelPilotSkill() {
    }

    public void addToPilot(Pilot pilot) {
        super.addToPilot(pilot);
        pilot.getSkills().remove(this.previous);
    }

    public final int getChance(int unitType, Pilot pilot) {
        int level = this.getLevel();
        if (level == 1) {
            return this.getUpgradeChance(1, unitType, pilot);
        }
        if (pilot.getSkills().has(this.previous)) {
            return this.getUpgradeChance(level + 1, unitType, pilot);
        }
        return 0;
    }
}

