/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import java.util.Enumeration;
import java.util.Hashtable;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.WeaponType;
import server.campaign.CampaignMain;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.SPilotSkill;

public class WeaponSpecialistSkill
extends SPilotSkill {
    public WeaponSpecialistSkill(int id) {
        super(id, "Weapon Specialist", "WS");
    }

    public WeaponSpecialistSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        return Integer.parseInt(CampaignMain.cm.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("weapon_specialist", true));
    }

    public int getBVMod(Entity unit) {
        return 0;
    }

    public int getBVMod(Entity unit, SPilot pilot) {
        int totalWeaponBV = 0;
        int weaponSpecialistBVBaseMod = Integer.parseInt(CampaignMain.cm.getConfig("WeaponSpecialistBaseBVMod"));
        Enumeration weaponsList = unit.getWeapons();
        while (weaponsList.hasMoreElements()) {
            Mounted weapons = (Mounted)weaponsList.nextElement();
            WeaponType weapon = (WeaponType)weapons.getType();
            if (!weapon.getName().equalsIgnoreCase(pilot.getWeapon())) continue;
            totalWeaponBV = (int)((double)totalWeaponBV + weapon.getBV(unit));
        }
        return totalWeaponBV * weaponSpecialistBVBaseMod / 100;
    }

    public void assignWeapon(Entity entity, Pilot pilot) {
        Hashtable<String, Boolean> uniqueWeapons = new Hashtable<String, Boolean>();
        String bannedWeapons = CampaignMain.cm.getConfig("BannedWSWeapons");
        for (int i = 0; i < entity.getWeaponList().size(); ++i) {
            Mounted m = (Mounted)entity.getWeaponList().elementAt(i);
            if (bannedWeapons.indexOf(m.getDesc()) >= 0) continue;
            uniqueWeapons.put(m.getName(), new Boolean(true));
        }
        int selectedWeapon = 0;
        if (uniqueWeapons.size() == 0) {
            return;
        }
        if (uniqueWeapons.size() > 1) {
            selectedWeapon = CampaignMain.cm.getR().nextInt(uniqueWeapons.size());
        }
        Enumeration e = uniqueWeapons.keys();
        while (e.hasMoreElements()) {
            String weaponName = (String)e.nextElement();
            if (selectedWeapon == 0) {
                pilot.setWeapon(weaponName);
                break;
            }
            --selectedWeapon;
        }
    }
}

