/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import java.util.StringTokenizer;
import server.campaign.SUnit;

public class MechStatistics
implements Cloneable,
Comparable {
    private Long ID;
    private String mechFileName;
    private int mechSize;
    private int gamesWon = 0;
    private int gamesPlayed = 0;
    private int timesScrapped = 0;
    private long lastTimeUpdated = 0L;
    private int OriginalBV = 0;
    private int currentGamesWon = 0;
    private int currentGamesPlayed = 0;

    public String getMechFileName() {
        return this.mechFileName;
    }

    public void setMechFileName(String mechFileName) {
        this.mechFileName = mechFileName;
    }

    public String toString() {
        String result = "";
        result = result + this.mechFileName;
        result = result + "*";
        result = result + this.mechSize;
        result = result + "*";
        result = result + this.gamesWon;
        result = result + "*";
        result = result + this.gamesPlayed;
        result = result + "*";
        result = result + this.timesScrapped;
        result = result + "*";
        result = result + this.lastTimeUpdated;
        result = result + "*";
        result = result + this.currentGamesWon;
        result = result + "*";
        result = result + this.currentGamesPlayed;
        result = result + "*";
        result = result + this.OriginalBV;
        return result;
    }

    public MechStatistics() {
    }

    public MechStatistics(String Filename, int mechsize) {
        this.mechFileName = Filename;
        this.mechSize = mechsize;
        this.gamesPlayed = 0;
        this.gamesWon = 0;
    }

    public MechStatistics(String s) {
        StringTokenizer ST = new StringTokenizer(s, "*");
        this.mechFileName = ST.nextToken();
        this.mechSize = Integer.parseInt(ST.nextToken());
        this.gamesWon = Integer.parseInt(ST.nextToken());
        this.gamesPlayed = Integer.parseInt(ST.nextToken());
        this.timesScrapped = Integer.parseInt(ST.nextToken());
        if (ST.hasMoreElements()) {
            this.lastTimeUpdated = Long.parseLong(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.currentGamesWon = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.currentGamesPlayed = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.OriginalBV = Integer.parseInt(ST.nextToken());
        }
    }

    public int getBV() {
        int baseBV = 0;
        this.currentGamesPlayed = this.gamesPlayed;
        this.currentGamesWon = this.gamesWon;
        baseBV = this.getOriginalBV();
        return baseBV;
    }

    public String addStats(int gamesPlayed, int gamesWon, int originalBV) {
        String result = "";
        this.setGamesPlayed(this.getGamesPlayed() + gamesPlayed);
        this.setGamesWon(this.getGamesWon() + gamesWon);
        if (this.getOriginalBV() == 0) {
            this.setOriginalBV(originalBV);
        }
        return result;
    }

    public int compareTo(Object o) {
        MechStatistics m = (MechStatistics)o;
        return this.getMechFileName().compareTo(m.getMechFileName());
    }

    public int getMechSize() {
        return this.mechSize;
    }

    public int getGamesPlayed() {
        return this.gamesPlayed;
    }

    public int getGamesWon() {
        return this.gamesWon;
    }

    public void setGamesPlayed(int gamesPlayed) {
        if (gamesPlayed != this.gamesPlayed) {
            this.lastTimeUpdated = System.currentTimeMillis();
        }
        this.gamesPlayed = gamesPlayed;
    }

    public void setGamesWon(int gamesWon) {
        this.gamesWon = gamesWon;
    }

    public int getTimesScrapped() {
        return this.timesScrapped;
    }

    public void setTimesScrapped(int timesScrapped) {
        this.timesScrapped = timesScrapped;
    }

    public long getLastTimeUpdated() {
        return this.lastTimeUpdated;
    }

    public void setLastTimeUpdated(long lastTimeUpdated) {
        this.lastTimeUpdated = lastTimeUpdated;
    }

    public Long getID() {
        return this.ID;
    }

    public void setID(Long id) {
        this.ID = id;
    }

    public void setMechSize(int mechSize) {
        this.mechSize = mechSize;
    }

    public int getOriginalBV() {
        if (this.OriginalBV == 0 && this.getMechFileName() != null) {
            SUnit unit = new SUnit();
            this.OriginalBV = unit.loadMech(this.getMechFileName()).calculateBattleValue();
            Object var1_1 = null;
        }
        return this.OriginalBV;
    }

    public void setOriginalBV(int OriginalBV) {
        this.OriginalBV = OriginalBV;
    }

    public int getCurrentGamesPlayed() {
        return this.currentGamesPlayed;
    }

    public int getCurrentGamesWon() {
        return this.currentGamesWon;
    }

    public void setCurrentGamesWon(int currentGamesWon) {
        this.currentGamesWon = currentGamesWon;
    }

    public void setCurrentGamesPlayed(int currentGamesPlayed) {
        this.currentGamesPlayed = currentGamesPlayed;
    }
}

