/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import common.House;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SUnit;
import server.campaign.SmallPlayer;
import server.campaign.util.EXPRankingContainer;
import server.campaign.util.HouseRankingHelpContainer;
import server.campaign.util.MechStatistics;

public class Statistics {
    public static String doGetMechStats(int size) {
        TreeSet<MechStatistics> Sorted = new TreeSet<MechStatistics>();
        Enumeration e = CampaignMain.cm.getMechStats().elements();
        while (e.hasMoreElements()) {
            MechStatistics m = (MechStatistics)e.nextElement();
            if (m.getMechSize() != size) continue;
            Sorted.add(m);
        }
        boolean color = false;
        Iterator i = Sorted.iterator();
        StringBuffer result = new StringBuffer();
        result.append("<h2>" + SUnit.getWeightClassDesc(size) + " Units</h2>");
        result.append("<table cellpadding=\"3\" cellspacing=\"0\"><tr bgcolor=\"#0066FF\"><th><font color=\"#FFFFFF\">MekName</th><th><font color=\"#FFFFFF\">Games Played</th><th><font color=\"#FFFFFF\">Games Won</th><th><font color=\"#FFFFFF\">Times Scrapped</th><th width=\"50\" align=\"center\"><font color=\"#FFFFFF\">BV</th></font><th><font color=\"#FFFFFF\">Last Used</font></th></tr>");
        while (i.hasNext()) {
            MechStatistics m = (MechStatistics)i.next();
            if (color) {
                result.append("<tr class=\"trcolored\"><td>");
            } else {
                result.append("<tr class=\"truncolored\"><td>");
            }
            color = !color;
            result.append("</td><td>");
            result.append(m.getMechFileName());
            result.append("</td><td>");
            result.append(m.getGamesPlayed());
            result.append("</td><td>");
            result.append(m.getGamesWon());
            result.append("</td><td>");
            result.append(m.getTimesScrapped());
            result.append("</td><td>");
            result.append(m.getOriginalBV());
            result.append("</td><td align=\"right\">");
            if (m.getLastTimeUpdated() > 0L) {
                result.append(CampaignMain.readableTime(System.currentTimeMillis() - m.getLastTimeUpdated()));
            } else {
                result.append("unknown");
            }
            result.append("</td></tr>\n\r");
        }
        result.append("</table>");
        return result.toString();
    }

    public static void doRanking() {
        Object p;
        StringBuffer result = new StringBuffer();
        result.append("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"format.css\"><style type=\"text/css\"></style></head><body><font face=\"Verdana, Arial, Helvetica, sans-serif\">");
        result.append("<h2>Player Ranking:</h2><p>");
        Iterator<House> e = CampaignMain.cm.getData().getAllHouses().iterator();
        Hashtable allplayers = new Hashtable();
        while (e.hasNext()) {
            SHouse h = (SHouse)e.next();
            if (h.isNewbieHouse()) continue;
            allplayers.putAll(h.getSmallPlayers());
        }
        TreeSet Sorted = new TreeSet(allplayers.values());
        Iterator i = Sorted.iterator();
        Vector v = new Vector();
        boolean color = false;
        while (i.hasNext()) {
            v.add(i.next());
        }
        result.append("<table cellpadding=\"3\" cellspacing=\"0\"><tr bgcolor=\"#0066FF\"><th><font color=\"#FFFFFF\">Rank</font></th><th><font color=\"#FFFFFF\">Name</th><th><font color=\"#FFFFFF\">Rating</th><th><font color=\"#FFFFFF\">House</th><th><font color=\"#FFFFFF\">House Rank</th><th><font color=\"#FFFFFF\">Comment</th></tr>");
        int rank = 1;
        for (int j = v.size() - 1; j >= 0; --j) {
            p = (SmallPlayer)v.elementAt(j);
            if (color) {
                result.append("<tr class=\"trcolored\">");
            } else {
                result.append("<tr class=\"truncolored\">");
            }
            color = !color;
            result.append("<td>" + rank + "</td>");
            result.append("<td>" + ((SmallPlayer)p).getName() + "</td>");
            if (Boolean.valueOf(CampaignMain.cm.getConfig("HideELO")).booleanValue()) {
                result.append("<td> -- </td>");
            } else {
                result.append("<td>" + ((SmallPlayer)p).getRatingRounded() + "</td>");
            }
            result.append("<td>" + ((SmallPlayer)p).getMyHouse().getColoredName() + "</td>");
            if (((SmallPlayer)p).getFluffText().equals("0")) {
                result.append("<td> </td>");
            } else {
                result.append("<td>" + ((SmallPlayer)p).getFluffText() + "</td>");
            }
            result.append("</tr>");
            ++rank;
        }
        result.append("</table>");
        result.append("</body></html>");
        try {
            FileOutputStream out = new FileOutputStream(CampaignMain.cm.getConfig("RankingPath"));
            p = new PrintStream(out);
            ((PrintStream)p).println(result.toString());
            ((PrintStream)p).close();
            out.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Statistics.doEXPRanking();
    }

    public static void doEXPRanking() {
        Object p;
        StringBuffer result = new StringBuffer();
        result.append("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"format.css\"><style type=\"text/css\"></style></head><body><font face=\"Verdana, Arial, Helvetica, sans-serif\">");
        result.append("<h2>Player Ranking:</h2><p>");
        Iterator<House> e = CampaignMain.cm.getData().getAllHouses().iterator();
        Hashtable<String, EXPRankingContainer> allplayers = new Hashtable<String, EXPRankingContainer>();
        while (e.hasNext()) {
            SHouse h = (SHouse)e.next();
            if (h.isNewbieHouse()) continue;
            Enumeration en = h.getSmallPlayers().elements();
            while (en.hasMoreElements()) {
                EXPRankingContainer EXPRankPlayer = new EXPRankingContainer((SmallPlayer)en.nextElement());
                allplayers.put(EXPRankPlayer.getName(), EXPRankPlayer);
            }
        }
        TreeSet Sorted = new TreeSet(allplayers.values());
        Iterator i = Sorted.iterator();
        Vector v = new Vector();
        while (i.hasNext()) {
            v.add(i.next());
        }
        result.append("<table cellpadding=\"3\" cellspacing=\"0\"><tr bgcolor=\"#0066FF\"><th><font color=\"#FFFFFF\">Rank</font></th><th><font color=\"#FFFFFF\">Name</th><th><font color=\"#FFFFFF\">Experience</th><th><font color=\"#FFFFFF\">House</th><th><font color=\"#FFFFFF\">House Rank</th><th><font color=\"#FFFFFF\">Comment</th></tr>");
        int rank = 1;
        boolean color = false;
        for (int j = v.size() - 1; j > 0 && j >= v.size() - 1000; --j) {
            if (color) {
                result.append("<tr class=\"trcolored\">");
            } else {
                result.append("<tr class=\"truncolored\">");
            }
            color = !color;
            p = (EXPRankingContainer)v.elementAt(j);
            result.append("<td>" + rank + "</td>");
            result.append("<td>" + ((EXPRankingContainer)p).getName() + "</td>");
            result.append("<td>" + ((EXPRankingContainer)p).getExperience() + "</td>");
            result.append("<td>" + ((EXPRankingContainer)p).getMyHouse().getColoredName() + "</td>");
            if (((EXPRankingContainer)p).getFluffText().equals("0")) {
                result.append("<td> </td>");
            } else {
                result.append("<td>" + ((EXPRankingContainer)p).getFluffText() + "</td>");
            }
            result.append("</tr>");
            ++rank;
        }
        result.append("</table>");
        result.append("</body></html>");
        try {
            FileOutputStream out = new FileOutputStream(CampaignMain.cm.getConfig("EXPRankingPath"));
            p = new PrintStream(out);
            ((PrintStream)p).println(result.toString());
            ((PrintStream)p).close();
            out.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static String getReadableHouseRanking(boolean useHTML) {
        String result = "<Font color=\"black\"><b><i>Faction Ranking:</i></b><br>";
        TreeSet s = CampaignMain.cm.getHouseRanking();
        for (HouseRankingHelpContainer h : s) {
            result = result + h.getHouse().getColoredNameAsLink() + " (";
            int diff = h.getAmount() - h.getHouse().getInitialHouseRanking();
            result = diff > 0 ? result + "+" + diff : result + diff;
            result = result + "/" + h.getAmount() + "), ";
        }
        if (useHTML) {
            result = result + "<br></font>";
        }
        return result;
    }
}

