/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.util.UnitHistoryEntry;

public class UnitHistoryKeeper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(UnitHistoryEntry ent) {
        if (CampaignMain.cm.useHibernate()) {
            Session session = CampaignMain.cm.getSession();
            Transaction tx = null;
            try {
                session = CampaignMain.cm.getFactory().openSession();
                tx = session.beginTransaction();
                session.saveOrUpdate((Object)ent);
                session.flush();
                tx.commit();
                session.close();
            }
            catch (Exception e) {
                MMServ.mmlog.mainLog("Error in first try");
                MMServ.mmlog.errLog(e);
            }
            finally {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void addProductionEntry(int UnitID, String Factory, String Planet2, String House2, String Filename) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 1);
        if (Planet2.equals("")) {
            historyEntry.setSource(Factory);
        } else {
            historyEntry.setSource(Factory + " (" + Planet2 + ")");
        }
        historyEntry.setSourceHouse(House2);
        historyEntry.setTarget(Filename);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addAcquireEntry(int UnitID, String acquirer, String acquirerHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 2);
        historyEntry.setTarget(acquirer);
        historyEntry.setTargetHouse(acquirerHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addRaidEntry(int UnitID, String source, String sourceHouse, String target, String targetHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 3);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        historyEntry.setTarget(target);
        historyEntry.setTargetHouse(targetHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addSalvageEntry(int UnitID, String source, String sourceHouse, String target, String targetHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 4);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        historyEntry.setTarget(target);
        historyEntry.setTargetHouse(targetHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addDonateEntry(int UnitID, String source, String sourceHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 5);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addScrapEntry(int UnitID, String source, String sourceHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 6);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addBoughtFromBayEntry(int UnitID, String source, String sourceHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 7);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addBoughtFromFactoryEntry(int UnitID, String source, String sourceHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 8);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addDestroyedEntry(int UnitID, String source, String sourceHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 9);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addDestroyedByAccidentEntry(int UnitID, String source, String sourceHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 10);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addSoldOnBMEntry(int UnitID, String target, String targetHouse, String source, String sourceHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 11);
        historyEntry.setTarget(target);
        historyEntry.setTargetHouse(targetHouse);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addParticipatedInGameEntry(int UnitID, String enemy, String enemyHouse, String gameType, String planet, String won) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 12);
        historyEntry.setTarget(enemy);
        historyEntry.setTargetHouse(enemyHouse);
        historyEntry.setSource(gameType + " on " + planet);
        historyEntry.setSourceHouse(won);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addPilotLevelUpEntry(int UnitID, String pilotName, int Gunnery, int Piloting, String Skills) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 13);
        String pilotString = pilotName + " (" + Gunnery + "/" + Piloting;
        if (!Skills.trim().equals("")) {
            pilotString = pilotString + ", " + Skills;
        }
        pilotString = pilotString + ")";
        historyEntry.setSource(pilotString);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addPilotSkillGainEntry(int UnitID, String pilotName, int Gunnery, int Piloting, String Skills) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 14);
        String pilotString = pilotName + " (" + Gunnery + "/" + Piloting;
        if (!Skills.trim().equals("")) {
            pilotString = pilotString + ", " + Skills;
        }
        pilotString = pilotString + ")";
        historyEntry.setSource(pilotString);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addaddPilotEntry(int UnitID, String pilotName, int Gunnery, int Piloting, String Skills) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 15);
        String pilotString = pilotName + " (" + Gunnery + "/" + Piloting;
        if (!Skills.trim().equals("")) {
            pilotString = pilotString + ", " + Skills;
        }
        pilotString = pilotString + ")";
        historyEntry.setSource(pilotString);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addSentEntry(int UnitID, String source, String sourceHouse, String target, String targetHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 16);
        historyEntry.setTarget(target);
        historyEntry.setTargetHouse(targetHouse);
        historyEntry.setSource(source);
        historyEntry.setSourceHouse(sourceHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addPilotChangeNameEntry(int UnitID, String oldName, String newName) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 17);
        historyEntry.setTarget(newName);
        historyEntry.setSource(oldName);
        UnitHistoryKeeper.addEntry(historyEntry);
    }

    public static void addUnitKilledUnitEntry(int UnitID, int KilledID, String killedOwner, String killedOwnerHouse) {
        UnitHistoryEntry historyEntry = new UnitHistoryEntry(UnitID, 18);
        historyEntry.setSource("" + KilledID);
        historyEntry.setTarget(killedOwner);
        historyEntry.setTargetHouse(killedOwnerHouse);
        UnitHistoryKeeper.addEntry(historyEntry);
    }
}

