/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import common.AdvanceTerrain;
import common.Continent;
import common.Influences;
import common.PlanetEnvironments;
import common.UnitFactories;
import gd.xml.ParseException;
import gd.xml.XMLParser;
import gd.xml.XMLResponder;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.NewbiePlanet;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SUnitFactory;
import server.campaign.util.TimeZoneData;

public class XMLPlanetDataParser
implements XMLResponder {
    String lastElement = "";
    String lastInfFaction = "";
    String Name = "";
    int Income;
    String MFName = null;
    String MFSize = null;
    String MFFounder = null;
    String MFProductionTable = null;
    int MFTicksUntilRefresh = 0;
    int MFRefreshSpeed = 100;
    int Type = 0;
    String XCood = null;
    String YCood = null;
    HashMap Influence = new HashMap();
    Hashtable TimeZone = new Hashtable();
    Vector planets = new Vector();
    CampaignMain myCampaign;
    TimeZoneData TZData = new TimeZoneData();
    UnitFactories unitFactories = new UnitFactories();
    private String filename;
    private String prefix;
    private String Description = "";
    private PlanetEnvironments PlanEnv = new PlanetEnvironments();
    private AdvanceTerrain AdvTerr = null;
    public TreeMap<Integer, AdvanceTerrain> AdvTerrTreeMap = new TreeMap();
    boolean conquerable = true;
    private int counter = 1;
    int xmap = 1;
    int ymap = 1;
    int xboard = 16;
    int yboard = 17;
    int lowtemp = 25;
    int hitemp = 25;
    double gravity = 1.0;
    boolean vacuum = false;
    int nightchance = 0;
    int nightmod = 0;
    boolean map = false;
    String mapname = "";
    String aterrainName = "";
    int CompProduction = 0;
    int Warefactionsize = 0;
    boolean inWarefaction = false;
    boolean inContinent = false;
    boolean hasAdvanceTerrain = false;
    int terrainProb = 0;
    String terrainName = "";
    private boolean newbiePlanet = false;

    public XMLPlanetDataParser(CampaignMain main, String filename) {
        this.myCampaign = main;
        this.filename = filename;
        try {
            XMLParser xp = new XMLParser();
            xp.parseXML(this);
        }
        catch (Exception ex) {
            MMServ.addToErrorLog(ex);
        }
    }

    public Vector getPlanets() {
        return this.planets;
    }

    public void recordNotationDeclaration(String name, String pubID, String sysID) throws ParseException {
        System.out.print(this.prefix + "!NOTATION: " + name);
        if (sysID != null) {
            System.out.print("  sysID = " + sysID);
        }
        MMServ.mmlog.mainLog("");
    }

    public void recordEntityDeclaration(String name, String value, String pubID, String sysID, String notation) throws ParseException {
        System.out.print(this.prefix + "!ENTITY: " + name);
        if (value != null) {
            System.out.print("  value = " + value);
        }
        if (pubID != null) {
            System.out.print("  pubID = " + pubID);
        }
        if (sysID != null) {
            System.out.print("  sysID = " + sysID);
        }
        if (notation != null) {
            System.out.print("  notation = " + notation);
        }
        MMServ.mmlog.mainLog("");
    }

    public void recordElementDeclaration(String name, String content) throws ParseException {
        System.out.print(this.prefix + "!ELEMENT: " + name);
        MMServ.mmlog.mainLog("  content = " + content);
    }

    public void recordAttlistDeclaration(String element, String attr, boolean notation, String type, String defmod, String def) throws ParseException {
        System.out.print(this.prefix + "!ATTLIST: " + element);
        System.out.print("  attr = " + attr);
        System.out.print("  type = " + (notation ? "NOTATIONS " : "") + type);
        System.out.print("  def. modifier = " + defmod);
        MMServ.mmlog.mainLog(def == null ? "" : "  def = " + notation);
    }

    public void recordDoctypeDeclaration(String name, String pubID, String sysID) throws ParseException {
        System.out.print(this.prefix + "!DOCTYPE: " + name);
        if (pubID != null) {
            System.out.print("  pubID = " + pubID);
        }
        if (sysID != null) {
            System.out.print("  sysID = " + sysID);
        }
        MMServ.mmlog.mainLog("");
        this.prefix = "";
    }

    public void recordDocStart() {
    }

    public void recordDocEnd() {
        MMServ.mmlog.mainLog("");
        MMServ.mmlog.mainLog("Parsing finished without error");
    }

    public void recordElementStart(String name, Hashtable attr) throws ParseException {
        this.lastElement = name;
        if (name.equalsIgnoreCase("WAREHOUSE")) {
            this.inWarefaction = true;
        }
        if (name.equalsIgnoreCase("CONTINENT")) {
            this.inContinent = true;
        }
        if (name.equalsIgnoreCase("ADVANCETERRAIN")) {
            this.hasAdvanceTerrain = true;
            this.AdvTerr = new AdvanceTerrain();
            if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseStaticMaps")).booleanValue()) {
                CampaignMain.cm.getConfig().setProperty("UseStaticMaps", "true");
                CampaignMain.cm.saveConfigureFile(CampaignMain.cm.getConfig(), CampaignMain.cm.getServer().getConfigParam("CAMPAIGNCONFIG"));
            }
        }
    }

    public void recordElementEnd(String name) throws ParseException {
        if (name.equalsIgnoreCase("TIMEZONE")) {
            this.TimeZone.put(this.TZData.getName(), this.TZData.clone());
            MMServ.mmlog.mainLog("TimeZone read: " + this.TZData.getName());
            this.TZData = new TimeZoneData();
        }
        if (name.equalsIgnoreCase("UNITFACTORY") && this.MFName != null && this.MFFounder != null && this.MFSize != null) {
            if (this.Type == 0) {
                this.Type = 0;
            }
            SUnitFactory mf = new SUnitFactory(this.MFName, null, this.MFSize, this.MFFounder, this.TimeZone, this.MFTicksUntilRefresh, this.MFRefreshSpeed, this.Type);
            if (this.MFProductionTable != null) {
                mf.setProductionTable(this.MFProductionTable);
            }
            this.unitFactories.add(mf);
            this.MFName = null;
            this.MFSize = null;
            this.MFFounder = null;
            this.MFTicksUntilRefresh = 0;
            this.MFRefreshSpeed = 100;
            this.Type = 0;
            this.MFProductionTable = null;
            this.TimeZone = new Hashtable();
        }
        if (name.equalsIgnoreCase("CONTINENT")) {
            Continent cont = new Continent(this.terrainProb, CampaignMain.cm.getData().getTerrainByName(this.terrainName));
            this.PlanEnv.add(cont);
            this.terrainProb = 0;
            this.terrainName = "";
            this.inContinent = false;
            if (this.hasAdvanceTerrain) {
                this.AdvTerrTreeMap.put(cont.getEnvironment().getId(), this.AdvTerr);
            }
        }
        if (name.equalsIgnoreCase("ADVANCETERRAIN")) {
            this.AdvTerr.setDisplayName(this.aterrainName);
            this.AdvTerr.setGravity(this.gravity);
            this.AdvTerr.setHighTemp(this.hitemp);
            this.AdvTerr.setLowTemp(this.lowtemp);
            this.AdvTerr.setStaticMap(this.map);
            this.AdvTerr.setStaticMapName(this.mapname);
            this.AdvTerr.setXBoardSize(this.xboard);
            this.AdvTerr.setXSize(this.xmap);
            this.AdvTerr.setNightChance(this.nightchance);
            this.AdvTerr.setNightTempMod(this.nightmod);
            this.AdvTerr.setYBoardSize(this.yboard);
            this.AdvTerr.setYSize(this.ymap);
            this.AdvTerr.setVacuum(this.vacuum);
        }
        if (name.equalsIgnoreCase("PLANET")) {
            MMServ.mmlog.mainLog("PLANET READ");
            SPlanet p = !this.newbiePlanet ? new SPlanet(this.counter++, this.Name, null, this.Income, this.CompProduction, Double.parseDouble(this.XCood), Double.parseDouble(this.YCood)) : new NewbiePlanet(this.counter++, this.Name, null, this.Income, this.CompProduction, Double.parseDouble(this.XCood), Double.parseDouble(this.YCood));
            for (int i = 0; i < this.unitFactories.size(); ++i) {
                SUnitFactory MF = (SUnitFactory)this.unitFactories.get(i);
                MF.setPlanet(p);
            }
            p.setUnitFactories(this.unitFactories);
            p.setEnvironments(this.PlanEnv);
            p.setDescription(this.Description);
            p.setBaysProvided(this.Warefactionsize);
            MMServ.mmlog.mainLog("Influence: " + this.Influence);
            p.setInfluence(new Influences(this.Influence));
            p.setConquerable(this.conquerable);
            p.setMapSize(new Dimension(this.xmap, this.ymap));
            p.setBoardSize(new Dimension(this.xboard, this.yboard));
            p.setTemp(new Dimension(this.lowtemp, this.hitemp));
            p.setGravity(this.gravity);
            p.setVacuum(this.vacuum);
            if (this.hasAdvanceTerrain) {
                p.getAdvanceTerrain().putAll(this.AdvTerrTreeMap);
            }
            this.planets.add(p);
            this.conquerable = true;
            this.Name = null;
            this.Income = 0;
            this.XCood = null;
            this.YCood = null;
            this.Influence = new HashMap();
            this.unitFactories = new UnitFactories();
            this.Description = "";
            this.PlanEnv = new PlanetEnvironments();
            this.Warefactionsize = 0;
            this.CompProduction = 0;
            this.newbiePlanet = false;
            this.hasAdvanceTerrain = false;
            this.xboard = -1;
            this.yboard = -1;
            this.nightchance = 0;
            this.nightmod = 0;
            this.map = false;
            this.mapname = "";
            this.aterrainName = "";
            this.gravity = 1.0;
            this.vacuum = false;
            this.lowtemp = 25;
            this.hitemp = 25;
            this.ymap = -1;
            this.xmap = -1;
            this.AdvTerr = null;
            this.AdvTerrTreeMap.clear();
        }
        if (name.equalsIgnoreCase("WAREHOUSE")) {
            this.inWarefaction = false;
        }
    }

    public void recordPI(String name, String pValue) {
        MMServ.mmlog.mainLog(this.prefix + "*" + name + " PI: " + pValue);
    }

    public void recordCharData(String charData) {
        if (charData.equalsIgnoreCase("")) {
            this.lastElement = "";
        }
        if (this.lastElement.equalsIgnoreCase("NAME")) {
            this.Name = charData;
            MMServ.mmlog.mainLog(this.Name);
        } else if (this.lastElement.equalsIgnoreCase("INCOME")) {
            this.Income = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("XCOOD")) {
            this.XCood = charData;
        } else if (this.lastElement.equalsIgnoreCase("YCOOD")) {
            this.YCood = charData;
        } else if (this.lastElement.equalsIgnoreCase("WAREHOUSE")) {
            this.Warefactionsize = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("FACTION")) {
            this.lastInfFaction = charData;
        } else if (this.lastElement.equalsIgnoreCase("AMOUNT")) {
            SHouse h = CampaignMain.cm.getHouseFromPartialString(this.lastInfFaction, null);
            if (h != null) {
                this.Influence.put(new Integer(h.getId()), new Integer(charData));
                MMServ.mmlog.mainLog("Parsed: " + h.toString() + " - " + charData);
            } else {
                MMServ.mmlog.mainLog("ERROR READING FACTION: " + this.lastInfFaction);
            }
        } else if (this.lastElement.equalsIgnoreCase("FACTORYNAME")) {
            this.MFName = charData;
        } else if (this.lastElement.equalsIgnoreCase("FOUNDER")) {
            this.MFFounder = charData;
        } else if (this.lastElement.equalsIgnoreCase("SIZE")) {
            if (this.inWarefaction) {
                this.Warefactionsize = Integer.parseInt(charData);
            } else if (this.inContinent) {
                this.terrainProb = Integer.parseInt(charData);
            } else {
                this.MFSize = charData;
            }
        } else if (this.lastElement.equalsIgnoreCase("TICKSUNTILREFRESH")) {
            this.MFTicksUntilRefresh = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("REFRESHSPEED")) {
            this.MFRefreshSpeed = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("TIMEZONENAME")) {
            this.TZData.setName(charData);
        } else if (this.lastElement.equalsIgnoreCase("TIMEZONEPROPABILITY")) {
            this.TZData.setPropability(Integer.parseInt(charData));
        } else if (this.lastElement.equalsIgnoreCase("TYPE")) {
            this.Type = charData.equalsIgnoreCase("VEHICLE") ? (this.Type += SUnitFactory.BUILDVEHICLES) : (charData.equalsIgnoreCase("INFANTRY") ? (this.Type += SUnitFactory.BUILDINFANTRY) : (charData.equalsIgnoreCase("BATTLEARMOR") ? (this.Type += SUnitFactory.BUILDBATTLEARMOR) : (charData.equalsIgnoreCase("PROTOMEK") ? (this.Type += SUnitFactory.BUILDPROTOMECHS) : (this.Type += SUnitFactory.BUILDMEK))));
        } else if (this.lastElement.equalsIgnoreCase("PRODUCTIONTABLE")) {
            this.MFProductionTable = charData;
        } else if (this.lastElement.equalsIgnoreCase("COMPPRODUCTION")) {
            this.CompProduction = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("CONQUERABLE")) {
            this.conquerable = Boolean.valueOf(charData);
        } else if (this.lastElement.equalsIgnoreCase("TERRAIN")) {
            this.terrainName = charData;
        } else if (this.lastElement.equalsIgnoreCase("NEWBIEPLANET")) {
            this.newbiePlanet = Boolean.valueOf(charData);
        } else if (this.lastElement.endsWith("XMAP")) {
            this.xmap = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("YMAP")) {
            this.ymap = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("XBOARD")) {
            this.xboard = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("YBOARD")) {
            this.yboard = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("LOWTEMP")) {
            this.lowtemp = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("HITEMP")) {
            this.hitemp = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("GRAVITY")) {
            this.gravity = Double.parseDouble(charData);
        } else if (this.lastElement.endsWith("VACUUM")) {
            this.vacuum = Boolean.valueOf(charData);
        } else if (this.lastElement.endsWith("MAP")) {
            this.map = Boolean.valueOf(charData);
        } else if (this.lastElement.endsWith("NIGHTCHANCE")) {
            this.nightchance = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("NIGHTMOD")) {
            this.nightmod = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("MAPNAME")) {
            this.mapname = charData;
        } else if (this.lastElement.endsWith("TERRAINNAME")) {
            this.aterrainName = charData;
        }
    }

    public void recordComment(String comment) {
        MMServ.mmlog.mainLog(this.prefix + "*Comment: " + comment);
    }

    public InputStream getDocumentStream() throws ParseException {
        try {
            return new FileInputStream(this.filename);
        }
        catch (FileNotFoundException e) {
            throw new ParseException("could not find the specified file");
        }
    }

    public InputStream resolveExternalEntity(String name, String pubID, String sysID) throws ParseException {
        if (sysID != null) {
            File f = new File(new File(this.filename).getParent(), sysID);
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new ParseException("file not found (" + f + ")");
            }
        }
        return null;
    }

    public InputStream resolveDTDEntity(String name, String pubID, String sysID) throws ParseException {
        return this.resolveExternalEntity(name, pubID, sysID);
    }

    public static String newLineToBR(String data) {
        StringTokenizer tokened = new StringTokenizer(data, "\n");
        String result = new String();
        while (tokened.hasMoreElements()) {
            result = result + tokened.nextElement();
            if (!tokened.hasMoreElements()) continue;
            result = result + "<BR>";
        }
        return result;
    }
}

