/*
 * Decompiled with CFR 0.152.
 */
package server.dataProvider.commands;

import common.CampaignData;
import common.util.BinWriter;
import common.util.MD5OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import server.MMServ;
import server.campaign.data.TimeUpdatePlanet;
import server.dataProvider.ServerCommand;

public class PDiff
implements ServerCommand {
    public void execute(Date timestamp, BinWriter out, CampaignData data) throws Exception {
        if (timestamp == null) {
            timestamp = new Date(0L);
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (TimeUpdatePlanet e : data.getAllPlanets()) {
            if (e.getLastChanged() == null || e.getLastChanged().compareTo(timestamp) <= 0) continue;
            ids.add(new Integer(e.getId()));
        }
        data.encodeMutablePlanets(out, ids);
        MD5OutputStream md5 = new MD5OutputStream();
        BinWriter md5Writer = new BinWriter(new PrintWriter(md5));
        data.binOut(md5Writer);
        md5Writer.close();
        MMServ.mmlog.mainLog("DataProvider: MD5 of all planets is: " + md5.getHashString());
        out.println(md5.getHashString(), "md5");
    }
}

