/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.persistence.auth.Auth;
import com.lyrisoft.chat.server.remote.persistence.auth.IAuthenticator;
import com.lyrisoft.chat.server.remote.persistence.auth.NullAuthenticator;
import com.lyrisoft.chat.server.remote.persistence.auth.Passwd;
import java.io.IOException;
import server.util.MMNetPasswd;
import server.util.MMNetPasswdRecord;

public class CustomPasswdAuthenticator
extends NullAuthenticator
implements IAuthenticator {
    public static final int PUBLIC = 0;
    public static final int GUEST = 1;
    public static final int REGISTERED = 2;
    public static final int CHAT_MODERATOR = 10;
    public static final int CAMPAIGN = 20;
    public static final int CAMPAIGN_MODERATOR = 100;
    public static final int GOD = 30;
    public static final int ADMIN = 200;
    int nobody_id = 0;

    public CustomPasswdAuthenticator(ChatServer server, boolean allowGuests, boolean storeGuests) {
        super(server, allowGuests, storeGuests);
    }

    public Auth authenticate(String userId, String password) throws AccessDenied {
        try {
            MMNetPasswdRecord record = MMNetPasswd.getRecord(userId.trim(), password.trim());
            if (record == null) {
                return new Auth(userId, 1);
            }
            return new Auth(userId, record.access);
        }
        catch (IOException e) {
            ChatServer.log(e);
            throw new AccessDenied(userId);
        }
    }

    public boolean isExistingUser(String user) {
        return super.isExistingUser(user) || Passwd.isExistingUser(user);
    }
}

