/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import server.util.BoolMatrixOps;
import server.util.FileOps;

public class IpCountry {
    private FileOps file = new FileOps();
    private FileOps fileNames;
    private static int dim = 32;
    int iteracion = 0;

    public IpCountry() {
    }

    public IpCountry(String fileIps, String fileNames) {
        this();
        this.file = new FileOps(fileIps);
        this.fileNames = new FileOps(fileNames);
    }

    private boolean[] ipToBytes(String ip) {
        boolean[] ipResult = new boolean[dim];
        int pos = ip.indexOf(".");
        int[] ipVal = new int[4];
        int pos2 = ip.indexOf(".", pos + 1);
        int pos3 = ip.indexOf(".", pos2 + 1);
        int pos4 = ip.length();
        int decVal = 0;
        ipVal[0] = Integer.parseInt(ip.substring(0, pos));
        ipVal[1] = Integer.parseInt(ip.substring(pos + 1, pos2));
        ipVal[2] = Integer.parseInt(ip.substring(pos2 + 1, pos3));
        ipVal[3] = Integer.parseInt(ip.substring(pos3 + 1, pos4));
        for (int i = ipResult.length - 1; i >= 0; --i) {
            decVal = (int)StrictMath.pow(2.0, (dim - i - 1) % (dim / 4));
            ipResult[i] = (decVal & ipVal[i / 8]) == decVal;
        }
        return ipResult;
    }

    public String seachIpCountry(String ipSource) {
        try {
            boolean[] ip = this.ipToBytes(ipSource);
            boolean[] ipTable = (boolean[])ip.clone();
            boolean[] mask = new boolean[]{true};
            String country = "Unknown";
            boolean found = false;
            boolean thisOne = false;
            String cad = "";
            this.file.openFile();
            while (!this.file.eofFile() && BoolMatrixOps.GreaterOrEqual(ip, ipTable)) {
                cad = this.file.getTextFromFile();
                ipTable = this.getIp(cad);
                mask = this.getMask(cad);
                thisOne = BoolMatrixOps.equal(BoolMatrixOps.and(ip, mask), ipTable);
                found |= thisOne;
                if (!thisOne) continue;
                country = this.getCountry(cad);
            }
            this.file.closeFile();
            return this.largeName(country, this.fileNames);
        }
        catch (Exception ex) {
            return "Moon";
        }
    }

    private boolean[] getIp(String cad) {
        try {
            return this.ipToBytes(cad.substring(cad.indexOf(":") + 1, cad.indexOf("/")));
        }
        catch (Exception ex) {
            return this.ipToBytes("0.0.0.0");
        }
    }

    private boolean[] getMask(String cad) {
        try {
            int pos = cad.indexOf("/");
            int mask = Integer.parseInt(cad.substring(pos + 1, cad.length()));
            boolean[] res = new boolean[dim];
            for (int i = 0; i < res.length; ++i) {
                res[i] = i < mask;
            }
            return res;
        }
        catch (Exception ex) {
            return this.ipToBytes("0.0.0.0");
        }
    }

    private String getCountry(String cad) {
        try {
            int pos = cad.indexOf(":");
            return cad.substring(0, pos);
        }
        catch (Exception ex) {
            return "Moon";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String largeName(String shortName, FileOps file) {
        String res = shortName;
        String current = "";
        String cad = "";
        file.openFile();
        try {
            while (!file.eofFile()) {
                cad = file.getTextFromFile();
                current = cad.substring(0, cad.indexOf(" ", 0));
                if (0 != current.compareTo(shortName)) continue;
                res = cad.substring(cad.indexOf(" ", 0), cad.length()).trim();
                break;
            }
        }
        catch (Exception ex) {
            res = "Moon";
        }
        finally {
            file.closeFile();
        }
        return res;
    }
}

