/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import common.util.UnitUtils;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Mounted;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;

class Repair {
    private Entity unit;
    private String Username;
    private int unitID;
    private boolean armor = false;
    private int location = -1;
    private int slot;
    private long repairTime;
    private long startTime;
    private long endTime;

    public Repair(SPlayer player, int unitID, boolean armor, int location, int slot) {
        this.unit = player.getUnit(unitID).getEntity();
        this.location = location;
        this.slot = slot;
        this.unitID = unitID;
        this.Username = player.getName();
        this.armor = armor;
        this.repairTime = Long.parseLong(CampaignMain.cm.getConfig("TimeForEachRepairPoint")) * 1000L;
        if (!armor) {
            CriticalSlot cs = this.unit.getCritical(location, slot);
            UnitUtils.setRepairing(this.unit, cs);
            MMServ.mmlog.errLog("number of crits " + UnitUtils.getNumberOfCrits(this.unit, cs));
            this.repairTime *= (long)UnitUtils.getNumberOfCrits(this.unit, cs);
            MMServ.mmlog.errLog("Repair Time: " + this.repairTime);
        }
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + this.repairTime;
    }

    public void finishRepair() {
        if (this.armor) {
            int armorRepaired = 0;
            boolean rear = false;
            if (this.slot == 0) {
                switch (this.location) {
                    case 8: {
                        this.location = 1;
                        rear = true;
                        break;
                    }
                    case 10: {
                        this.location = 3;
                        rear = true;
                        break;
                    }
                    case 9: {
                        this.location = 2;
                        rear = true;
                        break;
                    }
                    default: {
                        rear = false;
                    }
                }
                armorRepaired = this.unit.getOArmor(this.location, rear) - this.unit.getArmor(this.location, rear);
                this.unit.setArmor(this.unit.getOArmor(this.location, rear), this.location, rear);
                String points = " points ";
                if (armorRepaired == 1) {
                    points = " point ";
                }
                if (rear) {
                    CampaignMain.cm.toUser(armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + "r) where repaired on your " + this.unit.getShortNameRaw() + ".", this.Username, true);
                } else {
                    CampaignMain.cm.toUser(armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + ") where repaired on your " + this.unit.getShortNameRaw() + ".", this.Username, true);
                }
            } else {
                armorRepaired = this.unit.getOInternal(this.location) - this.unit.getInternal(this.location);
                this.unit.setInternal(this.unit.getOInternal(this.location), this.location);
                String points = " points ";
                if (armorRepaired == 1) {
                    points = " point ";
                }
                CampaignMain.cm.toUser(armorRepaired + points + "of interal armor(" + this.unit.getLocationAbbr(this.location) + ") where repaired on your " + this.unit.getShortNameRaw() + ".", this.Username, true);
            }
        } else {
            String repairMessage = "";
            CriticalSlot cs = this.unit.getCritical(this.location, this.slot);
            if (cs.getType() == 1) {
                Mounted mounted = this.unit.getEquipment(cs.getIndex());
                UnitUtils.repairEquipment(mounted, this.unit, this.location);
                repairMessage = "The " + mounted.getName() + "(" + this.unit.getLocationAbbr(this.location) + ") on the " + this.unit.getShortNameRaw() + " is now fully functional.";
            } else if (UnitUtils.isEngineCrit(cs)) {
                UnitUtils.repairDamagedEngine(this.unit);
                repairMessage = "All engines on the " + this.unit.getShortNameRaw() + " are now fully functional.";
            } else {
                if (this.unit instanceof Mech) {
                    repairMessage = "The " + ((Mech)this.unit).getSystemName(cs.getIndex()) + "(" + this.unit.getLocationAbbr(this.location) + ") of the " + this.unit.getShortName() + " is now fully functional.";
                }
                UnitUtils.fixCriticalSlot(cs, this.unit);
                this.unit.setCritical(this.location, this.slot, cs);
            }
            CampaignMain.cm.toUser(repairMessage, this.Username, true);
        }
        SPlayer player = CampaignMain.cm.getPlayer(this.Username);
        player.setSave(true);
        SUnit playerUnit = player.getUnit(this.unitID);
        CampaignMain.cm.toUser("PL|UU|" + playerUnit.getId() + "|" + playerUnit.toString(true), this.Username, false);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean matches(int unitID, int location, int slot) {
        return this.location == location && this.unitID == unitID && this.slot == slot;
    }
}

