/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import java.util.Vector;
import server.MMServ;
import server.campaign.SPlayer;
import server.util.Repair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepairTrackingThread
extends Thread {
    private Vector<Repair> repairList = new Vector();
    private long repairtime = 0L;

    public RepairTrackingThread(long Time) {
        this.repairtime = Time;
    }

    @Override
    public synchronized void run() {
        try {
            while (true) {
                this.wait(this.repairtime);
                this.checkRepairs();
            }
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Error while trying to sleep in RepairTrackingThread");
            MMServ.mmlog.errLog(ex);
            return;
        }
    }

    public void checkRepairs() {
        Vector<Repair> tempVector = new Vector<Repair>(this.repairList);
        for (Repair repairOrder : tempVector) {
            MMServ.mmlog.errLog("Start Time: " + repairOrder.getStartTime() + " End Time: " + repairOrder.getEndTime());
            if (repairOrder.getEndTime() > System.currentTimeMillis()) continue;
            repairOrder.finishRepair();
            this.repairList.removeElement(repairOrder);
        }
    }

    public Vector<Repair> getRepairList() {
        return this.repairList;
    }

    public boolean isBeingRepaired(int unitID, int location, int slot) {
        for (Repair repairOrder : this.getRepairList()) {
            if (!repairOrder.matches(unitID, location, slot)) continue;
            return true;
        }
        return false;
    }

    public static Repair Repair(SPlayer player, int unitID, boolean armor, int location, int slot) {
        return new Repair(player, unitID, armor, location, slot);
    }
}

