/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ojb.broker.accesslayer.ConnectionFactory;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class ConnectionFactoryAbstractImpl
implements ConnectionFactory {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl = ConnectionFactoryAbstractImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl);
    private Map dataSourceCache = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl;

    public abstract Connection getConnectionFromPool(JdbcConnectionDescriptor var1) throws LookupException;

    public abstract void returnConnectionToPool(JdbcConnectionDescriptor var1, Connection var2) throws LookupException;

    public void releaseConnection(JdbcConnectionDescriptor jcd, Connection con) {
        if (con == null) {
            return;
        }
        if (jcd.isDataSource()) {
            try {
                con.close();
            }
            catch (SQLException e) {
                this.log.error("Closing connection failed", e);
            }
        } else {
            try {
                this.returnConnectionToPool(jcd, con);
            }
            catch (LookupException e) {
                this.log.error("Unexpected exception when return connection " + con + " to pool using " + jcd, (Throwable)((Object)e));
            }
        }
    }

    public Connection lookupConnection(JdbcConnectionDescriptor jcd) throws LookupException {
        Connection conn;
        if (jcd.isDataSource()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("do datasource lookup, name: " + jcd.getDatasourceName() + ", user: " + jcd.getUserName());
            }
            conn = this.newConnectionFromDataSource(jcd);
        } else {
            conn = this.getConnectionFromPool(jcd);
            try {
                if (conn == null || conn.isClosed()) {
                    this.log.error("Connection for JdbcConnectionDiscriptor (" + (jcd.getDatasourceName() != null ? "datasource: " + jcd.getDatasourceName() : "db-url: " + this.getDbURL(jcd) + ", user: " + jcd.getUserName()) + ") was not valid, either *closed* or *null*");
                    throw new LookupException("Could not lookup valid connection from pool/DB, connection was " + conn);
                }
            }
            catch (SQLException e) {
                this.log.error("Error during sanity check of new DB Connection, either it was closed", e);
                throw new LookupException("Connection check failed", e);
            }
        }
        return conn;
    }

    protected void initializeJdbcConnection(Connection con, JdbcConnectionDescriptor jcd) throws LookupException {
        try {
            PlatformFactory.getPlatformFor(jcd).initializeJdbcConnection(jcd, con);
        }
        catch (PlatformException e) {
            throw new LookupException("Platform dependent initialization of connection failed", (Throwable)((Object)e));
        }
    }

    public synchronized void releaseAllResources() {
        this.dataSourceCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection newConnectionFromDataSource(JdbcConnectionDescriptor jcd) throws LookupException {
        Connection retval = null;
        DataSource ds = (DataSource)this.dataSourceCache.get(jcd.getDatasourceName());
        try {
            if (ds == null) {
                Map map = this.dataSourceCache;
                synchronized (map) {
                    InitialContext ic = new InitialContext();
                    ds = (DataSource)ic.lookup(jcd.getDatasourceName());
                    this.dataSourceCache.put(jcd.getDatasourceName(), ds);
                }
            }
            retval = jcd.getUserName() == null ? ds.getConnection() : ds.getConnection(jcd.getUserName(), jcd.getPassWord());
        }
        catch (SQLException sqlEx) {
            this.log.error("SQLException thrown while trying to get Connection from Datasource (" + jcd.getDatasourceName() + ")", sqlEx);
            throw new LookupException("SQLException thrown while trying to get Connection from Datasource (" + jcd.getDatasourceName() + ")", sqlEx);
        }
        catch (NamingException namingEx) {
            this.log.error("Naming Exception while looking up DataSource (" + jcd.getDatasourceName() + ")", namingEx);
            throw new LookupException("Naming Exception while looking up DataSource (" + jcd.getDatasourceName() + ")", namingEx);
        }
        this.initializeJdbcConnection(retval, jcd);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new connection using DataSource: " + retval);
        }
        return retval;
    }

    protected Connection newConnectionFromDriverManager(JdbcConnectionDescriptor jcd) throws LookupException {
        Connection retval = null;
        String driver = jcd.getDriver();
        String url = this.getDbURL(jcd);
        try {
            ClassHelper.getClass(driver, true);
            retval = jcd.getUserName() == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, jcd.getUserName(), jcd.getPassWord());
        }
        catch (SQLException sqlEx) {
            this.log.error("Error getting Connection from DriverManager with url (" + url + ") and driver (" + driver + ")", sqlEx);
            throw new LookupException("Error getting Connection from DriverManager with url (" + url + ") and driver (" + driver + ")", sqlEx);
        }
        catch (ClassNotFoundException cnfEx) {
            this.log.error(cnfEx);
            throw new LookupException("A class was not found", cnfEx);
        }
        catch (Exception e) {
            this.log.error("Instantiation of jdbc driver failed", e);
            throw new LookupException("Instantiation of jdbc driver failed", e);
        }
        this.initializeJdbcConnection(retval, jcd);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new connection using DriverManager: " + retval);
        }
        return retval;
    }

    protected String getDbURL(JdbcConnectionDescriptor jcd) {
        return jcd.isDataSource() ? jcd.getDatasourceName() : jcd.getProtocol() + ":" + jcd.getSubProtocol() + ":" + jcd.getDbAlias();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

