/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ojb.broker.ant.RepositoryVerifierHandler;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class VerifyMappingsTask
extends Task {
    private int m_errorCount = 0;
    private int m_warningCount = 0;
    private String m_repositoryPath = null;
    private String m_PropertiesFile = null;
    private String m_jdbcDriver = null;
    private String m_url = null;
    private String m_logon = null;
    private String m_password = null;
    private boolean m_ignoreCase = false;
    private boolean m_UseStrictTypeChecking = true;
    private Class m_persistenceClass = null;
    private boolean m_useXMLValidation = true;
    private boolean m_failOnError = true;
    private Path _classpath;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldPrivilegedImpl;

    public void setRepositoryFile(String path) {
        this.m_repositoryPath = path;
    }

    public String getRepositoryFile() {
        return this.m_repositoryPath;
    }

    public void setPropertiesFile(String path) {
        this.m_PropertiesFile = path;
    }

    public String getPropertiesFile() {
        return this.m_PropertiesFile;
    }

    public void setJdbcDriver(String jdbcClass) {
        this.m_jdbcDriver = jdbcClass;
    }

    public String getJdbcDriver() {
        return this.m_jdbcDriver;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setLogon(String logon) {
        this.m_logon = logon;
    }

    public String getLogon() {
        return this.m_logon;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setUseXMLValidation(String sValidationFlag) {
        this.m_useXMLValidation = Boolean.valueOf(sValidationFlag);
    }

    public boolean getUseXMLValidation() {
        return this.m_useXMLValidation;
    }

    public void setFailOnError(String sFailFlag) {
        this.m_failOnError = Boolean.valueOf(sFailFlag);
    }

    public boolean getFailOnError() {
        return this.m_failOnError;
    }

    public void setIgnoreFieldNameCase(String sIgnoreCaseFlag) {
        this.m_ignoreCase = Boolean.valueOf(sIgnoreCaseFlag);
    }

    public boolean getIgnoreFieldNameCase() {
        return this.m_ignoreCase;
    }

    public void setUseStrictTypeChecking(String sTypeCheckingFlag) {
        this.m_UseStrictTypeChecking = Boolean.valueOf(sTypeCheckingFlag);
    }

    public boolean getUseStrictTypeChecking() {
        return this.m_UseStrictTypeChecking;
    }

    public void setClasspath(Path classpath) {
        if (this._classpath == null) {
            this._classpath = classpath;
        } else {
            this._classpath.append(classpath);
        }
        this.log("Verification classpath is " + this._classpath, 3);
    }

    public Path createClasspath() {
        if (this._classpath == null) {
            this._classpath = new Path(this.getProject());
        }
        return this._classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
        this.log("Verification classpath is " + this._classpath, 3);
    }

    public void execute() throws BuildException {
        block4: {
            if (this.getRepositoryFile() == null) {
                throw new BuildException("Could not find the repository file.");
            }
            try {
                System.setProperty("OJB.properties", this.getPropertiesFile());
                this.logWarning("IgnoreFieldNameCase: " + String.valueOf(this.getIgnoreFieldNameCase()));
                this.logWarning("UseStrictTypeChecking: " + String.valueOf(this.getUseStrictTypeChecking()));
                this.logWarning("UseXMLValidation: " + String.valueOf(this.getUseXMLValidation()));
                this.logWarning("UseStrictTypeChecking: " + String.valueOf(this.getUseStrictTypeChecking()));
                this.verifyRepository(this.getRepositoryFile());
                this.logWarning(this.getSummaryString(this.getErrorCount(), this.getWarningCount()));
            }
            catch (Exception e) {
                this.logWarning("There was an exception while verifying the repsitory: " + e.getMessage());
                if (!this.getFailOnError()) break block4;
                throw new BuildException("There was an exception while verifying the repsitory.", (Throwable)e);
            }
        }
        if (this.getFailOnError() && this.getErrorCount() > 0) {
            throw new BuildException("Failed because 'failonerror' = true and there are " + String.valueOf(this.getErrorCount()) + " mapping error(s).");
        }
    }

    private String getSummaryString(int iBadCount, int iWarningCount) {
        return "\n---------------------------------------------------\n       Found " + String.valueOf(iBadCount) + " error(s) in the repository. \n       Found " + String.valueOf(iWarningCount) + " warning(s) in the repository.      \n---------------------------------------------------";
    }

    private void verifyRepository(String repositoryFile) throws ParserConfigurationException, SAXException, IOException {
        this.log("verifyRepository: Entered.");
        long start = System.currentTimeMillis();
        SAXParser p = SAXParserFactory.newInstance().newSAXParser();
        XMLReader reader = p.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/validation", this.getUseXMLValidation());
        RepositoryVerifierHandler handler = new RepositoryVerifierHandler(this);
        this.logInfo("Starting Parser...");
        reader.setContentHandler(handler);
        reader.parse(repositoryFile);
        this.logInfo("Done Parsing.");
        long stop = System.currentTimeMillis();
        this.setErrorCount(handler.getErrorCount());
        this.setWarningCount(handler.getWarningCount());
        this.logWarning("loading XML took " + (stop - start) + " msecs");
    }

    public void logWarning(String msg) {
        this.log(msg, 1);
    }

    public void logInfo(String msg) {
        this.log(msg, 2);
    }

    protected int getErrorCount() {
        return this.m_errorCount;
    }

    protected void setErrorCount(int count) {
        this.m_errorCount = count;
    }

    protected int getWarningCount() {
        return this.m_warningCount;
    }

    protected void setWarningCount(int count) {
        this.m_warningCount = count;
    }

    public boolean hasConnectionInfo() {
        return this.m_jdbcDriver != null && this.m_url != null && this.m_logon != null && this.m_password != null;
    }

    Class loadClass(String className) throws ClassNotFoundException {
        if (this._classpath != null) {
            this.log("Loading " + className + " using AntClassLoader with classpath " + this._classpath, 3);
            AntClassLoader loader = new AntClassLoader(this.getProject(), this._classpath);
            return loader.loadClass(className);
        }
        this.log("Loading " + className + " using system loader.", 3);
        return Class.forName(className);
    }

    public Class getPersistentFieldClass() {
        if (this.m_persistenceClass == null) {
            Properties properties = new Properties();
            try {
                this.logWarning("Loading properties file: " + this.getPropertiesFile());
                properties.load(new FileInputStream(this.getPropertiesFile()));
            }
            catch (IOException e) {
                this.logWarning("Could not load properties file '" + this.getPropertiesFile() + "'. Using PersistentFieldDefaultImpl.");
                e.printStackTrace();
            }
            try {
                String className = properties.getProperty("PersistentFieldClass");
                this.m_persistenceClass = this.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                this.m_persistenceClass = class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldPrivilegedImpl == null ? (class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldPrivilegedImpl = VerifyMappingsTask.class$("org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldPrivilegedImpl")) : class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldPrivilegedImpl;
            }
            this.logWarning("PersistentFieldClass: " + this.m_persistenceClass.toString());
        }
        return this.m_persistenceClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

