/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheDefaultImpl
implements ObjectCache,
PBStateListener {
    public static final String TIMEOUT_PROP = "timeout";
    public static final String AUTOSYNC_PROP = "autoSync";
    protected static Map objectTable = new Hashtable();
    private static ReferenceQueue queue = new ReferenceQueue();
    private static long hitCount = 0L;
    private static long failCount = 0L;
    private static long gcCount = 0L;
    protected PersistenceBroker broker;
    private List identitiesInWork;
    private boolean useAutoSync;
    private long timeout = 900000L;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl;

    public ObjectCacheDefaultImpl(PersistenceBroker broker, Properties prop) {
        this.broker = broker;
        this.timeout = prop == null ? this.timeout : Long.parseLong(prop.getProperty(TIMEOUT_PROP, "900")) * 1000L;
        boolean bl = this.useAutoSync = prop == null ? false : Boolean.valueOf(prop.getProperty(AUTOSYNC_PROP, "false").trim());
        if (this.useAutoSync && broker != null) {
            broker.addListener(this, true);
        }
        if (this.useAutoSync && broker == null) {
            LoggerFactory.getDefaultLogger().info("[" + (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl = ObjectCacheDefaultImpl.class$("org.apache.ojb.broker.cache.ObjectCacheDefaultImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl).getName() + "] Can't enable " + AUTOSYNC_PROP + ", because given PB instance is null");
        }
        this.identitiesInWork = new ArrayList();
    }

    public void clear() {
        this.processQueue();
        objectTable.clear();
        this.identitiesInWork.clear();
    }

    public void cache(Identity oid, Object obj) {
        this.processQueue();
        if (obj != null) {
            this.traceIdentity(oid);
            objectTable.put(oid, new CacheEntry(obj, oid, queue));
        }
    }

    public Object lookup(Identity oid) {
        this.processQueue();
        ++hitCount;
        Object result = null;
        CacheEntry entry = (CacheEntry)objectTable.get(oid);
        if (entry != null) {
            result = entry.get();
            if (result == null || entry.lifetime < System.currentTimeMillis()) {
                ++gcCount;
                this.remove(oid);
                result = null;
            } else {
                this.traceIdentity(oid);
            }
        } else {
            ++failCount;
        }
        return result;
    }

    public void remove(Identity oid) {
        this.processQueue();
        if (oid != null) {
            this.removeTracedIdentity(oid);
            objectTable.remove(oid);
        }
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("Count of cached objects", objectTable.keySet().size());
        buf.append("Lookup hits", hitCount);
        buf.append("Failures", failCount);
        buf.append("Reclaimed", gcCount);
        return buf.toString();
    }

    protected void finalize() {
        LoggerFactory.getDefaultLogger().debug("Finalize ObjectCache: " + this.toString());
    }

    private void traceIdentity(Identity oid) {
        if (this.useAutoSync && this.broker != null && this.broker.isInTransaction()) {
            this.identitiesInWork.add(oid);
        }
    }

    private void removeTracedIdentity(Identity oid) {
        this.identitiesInWork.remove(oid);
    }

    private void synchronizeWithTracedObjects() {
        LoggerFactory.getDefaultLogger().info("[" + this.getClass().getName() + "] tx was aborted," + " remove " + this.identitiesInWork.size() + " traced (potentially modified) objects from cache");
        Iterator iterator = this.identitiesInWork.iterator();
        while (iterator.hasNext()) {
            Identity oid = (Identity)iterator.next();
            objectTable.remove(oid);
        }
    }

    public void beforeRollback(PBStateEvent event) {
        this.synchronizeWithTracedObjects();
    }

    public void beforeCommit(PBStateEvent event) {
        this.identitiesInWork.clear();
    }

    public void beforeClose(PBStateEvent event) {
        this.identitiesInWork.clear();
    }

    public void afterRollback(PBStateEvent event) {
    }

    public void afterCommit(PBStateEvent event) {
    }

    public void afterBegin(PBStateEvent event) {
    }

    public void beforeBegin(PBStateEvent event) {
    }

    public void afterOpen(PBStateEvent event) {
    }

    private void processQueue() {
        CacheEntry sv;
        while ((sv = (CacheEntry)queue.poll()) != null) {
            this.removeTracedIdentity(sv.oid);
            objectTable.remove(sv.oid);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CacheEntry
    extends SoftReference {
        private final long lifetime;
        private final Identity oid;

        public CacheEntry(Object object, Identity k, ReferenceQueue q) {
            super(object, q);
            this.oid = k;
            this.lifetime = ObjectCacheDefaultImpl.this.timeout < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + ObjectCacheDefaultImpl.this.timeout;
        }
    }
}

