/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.collections.LRUMap;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;

public class ObjectCacheSoftImpl
implements ObjectCache,
Configurable {
    private static SoftHashMap cache = null;
    private static int size = 10000;

    public ObjectCacheSoftImpl(PersistenceBroker broker, Properties properties) {
        if (cache == null) {
            OjbConfigurator.getInstance().configure(this);
            cache = new SoftHashMap(size);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        size = configuration.getInteger("ObjectCacheSoftImpl", size);
    }

    public void cache(Identity oid, Object obj) {
        cache.put(oid, obj);
    }

    public Object lookup(Identity oid) {
        return cache.get(oid);
    }

    public void remove(Identity oid) {
        cache.remove(oid);
    }

    public void clear() {
        cache.clear();
    }

    public static final class SoftHashMap {
        private HashMap hash = new HashMap();
        private LRUMap hardCacheMap;
        private ReferenceQueue queue;

        public SoftHashMap(int hardSize) {
            this.hardCacheMap = new LRUMap(hardSize);
            this.queue = new ReferenceQueue();
        }

        public Object put(Object key, Object value) {
            if (key == null || value == null) {
                return null;
            }
            this.processQueue();
            this.hardCacheMap.put(key, value);
            return this.hash.put(key, new SoftValue(value, key, this.queue));
        }

        public Object get(Object key) {
            if (key == null) {
                return null;
            }
            Object result = null;
            SoftReference softRef = (SoftReference)this.hash.get(key);
            if (softRef != null) {
                result = softRef.get();
                if (result == null) {
                    this.hash.remove(key);
                } else if (!this.hardCacheMap.containsKey(key)) {
                    this.hardCacheMap.put(key, result);
                } else {
                    this.hardCacheMap.get(key);
                }
            }
            return result;
        }

        public Object remove(Object key) {
            this.processQueue();
            Object retval = null;
            Object value = this.hash.remove(key);
            if (value != null && value instanceof SoftValue) {
                retval = ((SoftValue)value).get();
            }
            return retval;
        }

        public void clear() {
            this.processQueue();
            this.hash.clear();
            this.hardCacheMap.clear();
        }

        private void processQueue() {
            SoftValue sv;
            while ((sv = (SoftValue)this.queue.poll()) != null) {
                this.hash.remove(sv.key);
            }
        }

        private class SoftValue
        extends SoftReference {
            private final Object key;

            private SoftValue(Object k, Object key, ReferenceQueue q) {
                super(k, q);
                this.key = key;
            }
        }
    }
}

