/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import org.apache.ojb.broker.query.UserAlias;
import org.apache.ojb.broker.query.ValueCriteria;

public class LikeCriteria
extends ValueCriteria {
    public static final char DEFAULT_ESCPAPE_CHARACTER = '\\';
    private static char escapeCharacter = (char)92;

    public LikeCriteria(Object anAttribute, Object aValue, String aClause, String anAlias) {
        super(anAttribute, (Object)LikeCriteria.generateSQLSearchPattern((String)aValue), aClause, anAlias);
    }

    public LikeCriteria(Object anAttribute, Object aValue, String aClause, UserAlias anAlias) {
        super(anAttribute, (Object)LikeCriteria.generateSQLSearchPattern((String)aValue), aClause, anAlias);
    }

    private static String generateSQLSearchPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuffer sqlpattern = new StringBuffer();
        char[] chars = pattern.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == escapeCharacter) {
                boolean oddEscapes;
                int x;
                for (x = i + 1; x < chars.length && chars[x] == escapeCharacter; ++x) {
                }
                boolean bl = oddEscapes = (x - i) % 2 > 0;
                if (oddEscapes) {
                    if (x < chars.length && (chars[x] == '%' || chars[x] == '_')) {
                        ++x;
                    } else {
                        ++i;
                        if (x < chars.length && (chars[x] == '*' || chars[x] == '?')) {
                            ++x;
                        }
                    }
                }
                if (i < chars.length) {
                    sqlpattern.append(chars, i, x - i);
                }
                i = x - 1;
                continue;
            }
            if (chars[i] == '*') {
                sqlpattern.append("%");
                continue;
            }
            if (chars[i] == '?') {
                sqlpattern.append("_");
                continue;
            }
            sqlpattern.append(chars[i]);
        }
        return sqlpattern.toString();
    }

    public static char getEscapeCharacter() {
        return escapeCharacter;
    }

    public static void setEscapeCharacter(char escChar) {
        escapeCharacter = escChar;
    }
}

