/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.io.InputStream;
import java.util.Properties;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.ConfigurationAbstractImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LoggingConfiguration
extends ConfigurationAbstractImpl {
    public static final String PROPERTY_COMMONS_LOGGING_LOG = "org.apache.commons.logging.Log";
    public static final String PROPERTY_COMMONS_LOGGING_LOGFACTORY = "org.apache.commons.logging.LogFactory";
    public static final String PROPERTY_OJB_LOGGERCLASS = "org.apache.ojb.broker.util.logging.Logger.class";
    public static final String PROPERTY_OJB_LOGGERCONFIGFILE = "org.apache.ojb.broker.util.logging.Logger.configFile";
    public static final String OJB_LOGGING_PROPERTIES_FILE = "OJB-logging.properties";
    public static final String OJB_DEFAULT_LOG_LEVEL = "WARN";
    private Class _loggerClass;
    private String _loggerConfigFile;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load() {
        InputStream ojbLogPropFile;
        Logger bootLogger = LoggerFactory.getBootLogger();
        ClassLoader contextLoader = ClassHelper.getClassLoader();
        String loggerClassName = null;
        this._loggerClass = null;
        this.properties = new Properties();
        loggerClassName = this.getLoggerClass(System.getProperties());
        this._loggerConfigFile = this.getLoggerConfigFile(System.getProperties());
        if (loggerClassName == null) {
            String ojbLoggingPropFile = System.getProperty(OJB_LOGGING_PROPERTIES_FILE, OJB_LOGGING_PROPERTIES_FILE);
            try {
                ojbLogPropFile = contextLoader.getResourceAsStream(OJB_LOGGING_PROPERTIES_FILE);
                if (ojbLogPropFile != null) {
                    bootLogger.debug("Found logging properties file OJB-logging.properties");
                    this.properties.load(ojbLogPropFile);
                    loggerClassName = this.getLoggerClass(this.properties);
                    this._loggerConfigFile = this.getLoggerConfigFile(this.properties);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (loggerClassName == null) {
            String ojbPropFile = System.getProperty("OJB.properties", "OJB.properties");
            try {
                ojbLogPropFile = contextLoader.getResourceAsStream(ojbPropFile);
                if (ojbLogPropFile != null) {
                    this.properties.load(ojbLogPropFile);
                    loggerClassName = this.getLoggerClass(this.properties);
                    this._loggerConfigFile = this.getLoggerConfigFile(this.properties);
                    if (loggerClassName == null) {
                        // empty if block
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (loggerClassName != null) {
            try {
                this._loggerClass = Class.forName(loggerClassName);
                return;
            }
            catch (ClassNotFoundException ex) {
                this._loggerClass = class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.PoorMansLoggerImpl")) : class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
                bootLogger.warn("Could not load logger class " + loggerClassName + ", defaulting to " + this._loggerClass.getName(), ex);
                return;
            }
        }
        if (System.getProperty(PROPERTY_COMMONS_LOGGING_LOG) != null || System.getProperty(PROPERTY_COMMONS_LOGGING_LOGFACTORY) != null) {
            this._loggerClass = class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.CommonsLoggerImpl")) : class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
            return;
        }
        try {
            if (contextLoader.getResourceAsStream("log4j.properties") != null) {
                this._loggerClass = class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.Log4jLoggerImpl")) : class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;
                this._loggerConfigFile = "log4j.properties";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this._loggerClass != null) return;
        try {
            if (contextLoader.getResourceAsStream("commons-logging.properties") != null) {
                this._loggerClass = class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.CommonsLoggerImpl")) : class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
                this._loggerConfigFile = "commons-logging.properties";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this._loggerClass = class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.PoorMansLoggerImpl")) : class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
    }

    private String getLoggerClass(Properties props) {
        String loggerClassName = props.getProperty(PROPERTY_OJB_LOGGERCLASS);
        if (loggerClassName == null) {
            loggerClassName = props.getProperty("LoggerClass");
        }
        return loggerClassName;
    }

    private String getLoggerConfigFile(Properties props) {
        String loggerConfigFile = props.getProperty(PROPERTY_OJB_LOGGERCONFIGFILE);
        if (loggerConfigFile == null) {
            loggerConfigFile = props.getProperty("LoggerConfigFile");
        }
        return loggerConfigFile;
    }

    public String getLogLevel(String loggerName) {
        return this.getString(loggerName + ".LogLevel", this.getString("ROOT.LogLevel", OJB_DEFAULT_LOG_LEVEL));
    }

    public void setLogger(Logger loggerInstance) {
    }

    public Class getLoggerClass() {
        return this._loggerClass;
    }

    public String getLoggerConfigFile() {
        return this._loggerConfigFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

