/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DListIterator;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryInvalidException;

public class DListImpl
extends AbstractList
implements DList,
DArray,
ManageableCollection,
Serializable {
    private static final long serialVersionUID = -835415723401679339L;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DListImpl == null ? (class$org$apache$ojb$odmg$collections$DListImpl = DListImpl.class$("org.apache.ojb.odmg.collections.DListImpl")) : class$org$apache$ojb$odmg$collections$DListImpl);
    private int id = -1;
    private Vector elements = new Vector();
    private int size;
    protected PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DListImpl;

    public DListImpl() {
        this.size = 0;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DListImpl(PBKey pbKey) {
        this.size = 0;
        this.pbKey = pbKey;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DListImpl(int theId, int theSize) {
        this.id = theId;
        this.size = theSize;
    }

    public PBKey getPBKey() {
        return this.pbKey;
    }

    public void setPBKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    public void add(int index, Object element) {
        ++this.size;
        DListEntry entry = new DListEntry(this, element);
        this.elements.add(index, entry);
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        if (tx != null && tx.isOpen()) {
            tx.lock(this, 4);
            tx.lock(entry, 4);
            tx.lock(element, 1);
        }
        int offset = 0;
        try {
            offset = ((DListEntry)this.elements.get(index - 1)).getPosition();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        for (int i = offset; i < this.elements.size(); ++i) {
            entry = (DListEntry)this.elements.get(i);
            entry.setPosition(i);
        }
    }

    public Object remove(int index) {
        DListEntry entry = (DListEntry)this.elements.get(index);
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        if (tx != null && tx.isOpen()) {
            tx.markDelete(entry);
        }
        --this.size;
        this.elements.remove(index);
        int offset = 0;
        try {
            offset = ((DListEntry)this.elements.get(index)).getPosition();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        for (int i = offset; i < this.elements.size(); ++i) {
            entry = (DListEntry)this.elements.get(i);
            entry.setPosition(i);
        }
        return entry.getRealSubject();
    }

    public DList concat(DList otherList) {
        DListImpl result = new DListImpl(this.pbKey);
        result.addAll(this);
        result.addAll(otherList);
        return result;
    }

    public boolean existsElement(String predicate) throws QueryInvalidException {
        DList results = (DList)this.query(predicate);
        return results != null && results.size() != 0;
    }

    protected int generateNewId() {
        PBCapsule capsule = new PBCapsule(null, TxManagerFactory.instance().getTransaction());
        try {
            int result;
            PersistenceBroker broker = capsule.getBroker();
            FieldDescriptor fld = broker.getClassDescriptor(this.getClass()).getAutoIncrementFields()[0];
            Integer val = (Integer)broker.serviceSequenceManager().getUniqueValue(fld);
            int n = result = val.intValue();
            return n;
        }
        catch (Exception e) {
            this.log.error("Generation of new id failed", e);
            throw new PersistenceBrokerException(e);
        }
        finally {
            capsule.destroy();
        }
    }

    public Object get(int index) {
        DListEntry entry = (DListEntry)this.elements.get(index);
        return entry.getRealSubject();
    }

    public Vector getElements() {
        return this.elements;
    }

    public int getId() {
        if (this.id == -1) {
            this.id = this.generateNewId();
        }
        return this.id;
    }

    public Iterator iterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator(int index) {
        return new DListIterator(this, index);
    }

    private Criteria getPkCriteriaForAllElements(PersistenceBroker brokerForClass) {
        try {
            Criteria crit = null;
            for (int i = 0; i < this.elements.size(); ++i) {
                DListEntry entry = (DListEntry)this.elements.get(i);
                Object obj = entry.getRealSubject();
                ClassDescriptor cld = brokerForClass.getClassDescriptor(obj.getClass());
                FieldDescriptor[] pkFields = cld.getPkFields();
                ValueContainer[] pkValues = brokerForClass.serviceBrokerHelper().getKeyValues(cld, obj);
                Criteria criteria = new Criteria();
                for (int j = 0; j < pkFields.length; ++j) {
                    FieldDescriptor fld = pkFields[j];
                    criteria.addEqualTo(fld.getPersistentField().getName(), pkValues[j].getValue());
                }
                if (crit == null) {
                    crit = criteria;
                    continue;
                }
                crit.addOrCriteria(criteria);
            }
            return crit;
        }
        catch (PersistenceBrokerException e) {
            return null;
        }
    }

    private Class getElementsExtentClass(PersistenceBroker brokerForClass) throws PersistenceBrokerException {
        DListEntry entry = (DListEntry)this.elements.get(0);
        Class<?> elementsClass = entry.getRealSubject().getClass();
        Class extentClass = brokerForClass.getTopLevelClass(elementsClass);
        return extentClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public DCollection query(String predicate) throws QueryInvalidException {
        void var7_12;
        String oql = "select all from java.lang.Object where " + predicate;
        OQLQueryImpl predicateQuery = new OQLQueryImpl(this.pbKey);
        predicateQuery.create(oql);
        Query pQ = predicateQuery.getQuery();
        Criteria pCrit = pQ.getCriteria();
        PBCapsule handle = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
        try {
            PersistenceBroker broker = handle.getBroker();
            Criteria allElementsCriteria = this.getPkCriteriaForAllElements(broker);
            allElementsCriteria.addAndCriteria(pCrit);
            Class clazz = null;
            try {
                clazz = this.getElementsExtentClass(broker);
            }
            catch (PersistenceBrokerException e) {
                throw new ODMGRuntimeException(e.getMessage());
            }
            QueryByCriteria q = new QueryByCriteria(clazz, allElementsCriteria);
            if (this.log.isDebugEnabled()) {
                this.log.debug(((Object)q).toString());
            }
            DListImpl result = null;
            try {
                result = (DListImpl)broker.getCollectionByQuery(class$org$apache$ojb$odmg$collections$DListImpl == null ? (class$org$apache$ojb$odmg$collections$DListImpl = DListImpl.class$("org.apache.ojb.odmg.collections.DListImpl")) : class$org$apache$ojb$odmg$collections$DListImpl, q);
            }
            catch (PersistenceBrokerException e) {
                this.log.error("Query failed", (Throwable)((Object)e));
                throw new OJBRuntimeException((Throwable)((Object)e));
            }
        }
        finally {
            if (handle != null) {
                handle.destroy();
            }
        }
        return var7_12;
    }

    public Iterator select(String predicate) throws QueryInvalidException {
        return this.query(predicate).iterator();
    }

    public Object selectElement(String predicate) throws QueryInvalidException {
        return ((DList)this.query(predicate)).get(0);
    }

    public int size() {
        return this.elements.size();
    }

    public void ojbAdd(Object anObject) {
        ++this.size;
        DListEntry entry = new DListEntry(this, anObject);
        entry.setPosition(this.elements.size());
        this.elements.add(entry);
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        Iterator it = otherCollection.ojbIterator();
        while (it.hasNext()) {
            this.ojbAdd(it.next());
        }
    }

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void resize(int newSize) {
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

