/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.collections.ManageableHashSet;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DMapEntry;
import org.odmg.DMap;

public class DMapImpl
extends AbstractMap
implements DMap,
Serializable {
    private static final long serialVersionUID = 7048246616243056480L;
    private int id = -1;
    private ManageableHashSet entries;
    private int size = 0;
    private PBKey pbKey;

    public DMapImpl() {
        this.entries = new ManageableHashSet();
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DMapImpl(PBKey key) {
        this.entries = new ManageableHashSet();
        this.pbKey = key;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DMapImpl(int theId, int theSize) {
        this.id = theId;
        this.size = theSize;
    }

    public PBKey getPBKey() {
        return this.pbKey;
    }

    public void setPBKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    public Set entrySet() {
        return this.entries;
    }

    protected int generateNewId() {
        PBCapsule capsule = new PBCapsule(null, TxManagerFactory.instance().getTransaction());
        try {
            int result;
            PersistenceBroker broker = capsule.getBroker();
            FieldDescriptor fld = broker.getClassDescriptor(this.getClass()).getAutoIncrementFields()[0];
            Integer val = (Integer)broker.serviceSequenceManager().getUniqueValue(fld);
            int n = result = val.intValue();
            return n;
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().error("DMapImpl: Generation of new id failed", e);
            throw new PersistenceBrokerException(e);
        }
        finally {
            capsule.destroy();
        }
    }

    public int getId() {
        if (this.id == -1) {
            this.id = this.generateNewId();
        }
        return this.id;
    }

    public Object put(Object key, Object value) {
        DMapEntry entry = new DMapEntry(this, key, value);
        boolean ok = this.entries.add(entry);
        if (ok) {
            TransactionImpl tx = TxManagerFactory.instance().getTransaction();
            if (tx != null && tx.isOpen()) {
                tx.lock(this, 4);
                tx.lock(entry, 4);
                tx.lock(key, 1);
                tx.lock(value, 1);
            }
            return null;
        }
        return this.get(key);
    }

    public Object remove(Object key) {
        DMapEntry e;
        Iterator i = this.entrySet().iterator();
        DMapEntry correctEntry = null;
        if (key == null) {
            while (correctEntry == null && i.hasNext()) {
                e = (DMapEntry)i.next();
                if (e.getKey() != null) continue;
                correctEntry = e;
            }
        } else {
            while (correctEntry == null && i.hasNext()) {
                e = (DMapEntry)i.next();
                if (!key.equals(e.getKey())) continue;
                correctEntry = e;
            }
        }
        Object oldValue = null;
        if (correctEntry != null) {
            oldValue = correctEntry.getValue();
            i.remove();
            TransactionImpl tx = TxManagerFactory.instance().getTransaction();
            if (tx != null && tx.isOpen()) {
                tx.markDelete(correctEntry);
            }
        }
        return oldValue;
    }

    public ManageableHashSet getEntries() {
        return this.entries;
    }

    public void setEntries(ManageableHashSet entries) {
        this.entries = entries;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

