/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Collection;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.LockEntry;
import org.apache.ojb.odmg.locking.LockMap;
import org.apache.ojb.odmg.locking.LockStrategyFactory;

public class RemoteLockMapImpl
implements LockMap,
Configurable {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$locking$RemoteLockMapImpl == null ? (class$org$apache$ojb$odmg$locking$RemoteLockMapImpl = RemoteLockMapImpl.class$("org.apache.ojb.odmg.locking.RemoteLockMapImpl")) : class$org$apache$ojb$odmg$locking$RemoteLockMapImpl);
    private static URL lockservlet = null;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$RemoteLockMapImpl;

    private PersistenceBroker getBroker() {
        return TxManagerFactory.instance().getCurrentTransaction().getBroker();
    }

    public LockEntry getWriter(Object obj) {
        PersistenceBroker broker = this.getBroker();
        Identity oid = new Identity(obj, broker);
        LockEntry result = null;
        try {
            result = this.getWriterRemote(oid);
        }
        catch (Throwable e) {
            this.log.error(e);
        }
        return result;
    }

    private LockEntry getWriterRemote(Identity oid) throws MalformedURLException, IOException, ProtocolException, ClassNotFoundException {
        byte selector = 119;
        byte[] requestBarr = this.buildRequestArray(oid, selector);
        HttpURLConnection conn = this.getHttpUrlConnection();
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        out.write(requestBarr, 0, requestBarr.length);
        out.flush();
        out.close();
        InputStream in = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(in);
        LockEntry result = (LockEntry)ois.readObject();
        ois.close();
        conn.disconnect();
        return result;
    }

    private HttpURLConnection getHttpUrlConnection() throws MalformedURLException, IOException, ProtocolException {
        URL lockserver = this.getLockserverUrl();
        HttpURLConnection conn = (HttpURLConnection)lockserver.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setAllowUserInteraction(false);
        conn.setUseCaches(false);
        return conn;
    }

    private byte[] buildRequestArray(Object object, byte selector) throws IOException {
        byte[] serialObj = this.serialize(object);
        int len = serialObj.length;
        byte[] requestBarr = new byte[len + 1];
        requestBarr[0] = selector;
        System.arraycopy(serialObj, 0, requestBarr, 1, len);
        return requestBarr;
    }

    private URL getLockserverUrl() throws MalformedURLException {
        return lockservlet;
    }

    public Collection getReaders(Object obj) {
        Collection result = null;
        try {
            Identity oid = new Identity(obj, this.getBroker());
            byte selector = 114;
            byte[] requestBarr = this.buildRequestArray(oid, selector);
            HttpURLConnection conn = this.getHttpUrlConnection();
            BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
            out.write(requestBarr, 0, requestBarr.length);
            out.flush();
            InputStream in = conn.getInputStream();
            ObjectInputStream ois = new ObjectInputStream(in);
            result = (Collection)ois.readObject();
            ois.close();
            out.close();
            conn.disconnect();
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
        return result;
    }

    public boolean addReader(TransactionImpl tx, Object obj) {
        try {
            LockEntry lock = new LockEntry(new Identity(obj, this.getBroker()).toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj), LockEntry.LOCK_READ);
            this.addReaderRemote(lock);
            return true;
        }
        catch (Throwable t) {
            this.log.error("Cannot store LockEntry for object " + obj + " in transaction " + tx, t);
            return false;
        }
    }

    private void addReaderRemote(LockEntry lock) throws IOException, ClassNotFoundException {
        byte selector = 97;
        byte[] requestBarr = this.buildRequestArray(lock, selector);
        HttpURLConnection conn = this.getHttpUrlConnection();
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        out.write(requestBarr, 0, requestBarr.length);
        out.flush();
        InputStream in = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(in);
        Boolean result = (Boolean)ois.readObject();
        ois.close();
        out.close();
        conn.disconnect();
        if (!result.booleanValue()) {
            throw new PersistenceBrokerException("could not add reader!");
        }
    }

    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bao);
        oos.writeObject(obj);
        oos.close();
        bao.close();
        byte[] result = bao.toByteArray();
        return result;
    }

    public void removeReader(TransactionImpl tx, Object obj) {
        try {
            LockEntry lock = new LockEntry(new Identity(obj, this.getBroker()).toString(), tx.getGUID());
            this.removeReaderRemote(lock);
        }
        catch (Throwable t) {
            this.log.error("Cannot remove LockEntry for object " + obj + " in transaction " + tx);
        }
    }

    private void removeReaderRemote(LockEntry lock) throws IOException, ClassNotFoundException {
        byte selector = 101;
        byte[] requestBarr = this.buildRequestArray(lock, selector);
        HttpURLConnection conn = this.getHttpUrlConnection();
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        out.write(requestBarr, 0, requestBarr.length);
        out.flush();
        InputStream in = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(in);
        Boolean result = (Boolean)ois.readObject();
        ois.close();
        out.close();
        conn.disconnect();
        if (!result.booleanValue()) {
            throw new PersistenceBrokerException("could not remove reader!");
        }
    }

    public void removeWriter(LockEntry writer) {
        try {
            this.removeWriterRemote(writer);
        }
        catch (Throwable t) {
            this.log.error("Cannot remove LockEntry", t);
        }
    }

    private void removeWriterRemote(LockEntry lock) throws IOException, ClassNotFoundException {
        byte selector = 109;
        byte[] requestBarr = this.buildRequestArray(lock, selector);
        HttpURLConnection conn = this.getHttpUrlConnection();
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        out.write(requestBarr, 0, requestBarr.length);
        out.flush();
        InputStream in = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(in);
        Boolean result = (Boolean)ois.readObject();
        ois.close();
        out.close();
        conn.disconnect();
        if (!result.booleanValue()) {
            throw new PersistenceBrokerException("could not remove writer!");
        }
    }

    public boolean upgradeLock(LockEntry reader) {
        try {
            this.upgradeLockRemote(reader);
            reader.setLockType(LockEntry.LOCK_WRITE);
            return true;
        }
        catch (Throwable t) {
            this.log.error("Cannot upgrade LockEntry " + reader, t);
            return false;
        }
    }

    private void upgradeLockRemote(LockEntry lock) throws IOException, ClassNotFoundException {
        byte selector = 117;
        byte[] requestBarr = this.buildRequestArray(lock, selector);
        HttpURLConnection conn = this.getHttpUrlConnection();
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        out.write(requestBarr, 0, requestBarr.length);
        out.flush();
        InputStream in = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(in);
        Boolean result = (Boolean)ois.readObject();
        ois.close();
        out.close();
        conn.disconnect();
        if (!result.booleanValue()) {
            throw new PersistenceBrokerException("could not remove writer!");
        }
    }

    public boolean setWriter(TransactionImpl tx, Object obj) {
        try {
            LockEntry lock = new LockEntry(new Identity(obj, this.getBroker()).toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj), LockEntry.LOCK_WRITE);
            this.setWriterRemote(lock);
            return true;
        }
        catch (Throwable t) {
            this.log.error("Cannot set LockEntry for object " + obj + " in transaction " + tx);
            return false;
        }
    }

    private void setWriterRemote(LockEntry lock) throws IOException, ClassNotFoundException {
        byte selector = 115;
        byte[] requestBarr = this.buildRequestArray(lock, selector);
        HttpURLConnection conn = this.getHttpUrlConnection();
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        out.write(requestBarr, 0, requestBarr.length);
        out.flush();
        InputStream in = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(in);
        Boolean result = (Boolean)ois.readObject();
        ois.close();
        out.close();
        conn.disconnect();
        if (!result.booleanValue()) {
            throw new PersistenceBrokerException("could not set writer!");
        }
    }

    public boolean hasReadLock(TransactionImpl tx, Object obj) {
        try {
            LockEntry lock = new LockEntry(new Identity(obj, this.getBroker()).toString(), tx.getGUID());
            boolean result = this.hasReadLockRemote(lock);
            return result;
        }
        catch (Throwable t) {
            this.log.error("Cannot check read lock for object " + obj + " in transaction " + tx, t);
            return false;
        }
    }

    private boolean hasReadLockRemote(LockEntry lock) throws IOException, ClassNotFoundException {
        byte selector = 104;
        byte[] requestBarr = this.buildRequestArray(lock, selector);
        HttpURLConnection conn = this.getHttpUrlConnection();
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        out.write(requestBarr, 0, requestBarr.length);
        out.flush();
        InputStream in = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(in);
        Boolean result = (Boolean)ois.readObject();
        ois.close();
        out.close();
        conn.disconnect();
        return result;
    }

    public void configure(Configuration pConfig) throws ConfigurationException {
        String url = pConfig.getString("LockServletUrl", "http://127.0.0.1:8080/ojb-lockserver");
        try {
            lockservlet = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid LockServlet Url was specified: " + url, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

