/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.oql;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.util.collections.ManageableArrayList;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.OdmgConfiguration;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLLexer;
import org.apache.ojb.odmg.oql.OQLParser;
import org.odmg.QueryException;
import org.odmg.QueryInvalidException;
import org.odmg.QueryParameterCountInvalidException;
import org.odmg.QueryParameterTypeInvalidException;
import org.odmg.Transaction;

public class OQLQueryImpl
implements EnhancedOQLQuery,
Configurable {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$oql$OQLQueryImpl == null ? (class$org$apache$ojb$odmg$oql$OQLQueryImpl = OQLQueryImpl.class$("org.apache.ojb.odmg.oql.OQLQueryImpl")) : class$org$apache$ojb$odmg$oql$OQLQueryImpl);
    private Class collectionClass;
    private Query query = null;
    private ListIterator bindIterator = null;
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$oql$OQLQueryImpl;

    public OQLQueryImpl(PBKey key) {
        this.pbKey = key;
    }

    public Query getQuery() {
        return this.query;
    }

    protected Class getCollectionClass() {
        return this.collectionClass;
    }

    public void bind(Object parameter) throws QueryParameterCountInvalidException, QueryParameterTypeInvalidException {
        try {
            SelectionCriteria crit = (SelectionCriteria)this.getBindIterator().next();
            crit.bind(parameter);
            if (crit instanceof BetweenCriteria && !crit.isBound()) {
                this.getBindIterator().previous();
            }
        }
        catch (Exception e) {
            throw new QueryParameterCountInvalidException(e.getMessage());
        }
    }

    private Vector flatten(Criteria crit, Vector acc) {
        Enumeration e = crit.getElements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                Criteria pc = (Criteria)o;
                this.flatten(pc, acc);
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            if (c.isBound()) continue;
            acc.add(c);
        }
        return acc;
    }

    public void create(String queryString) throws QueryInvalidException {
        this.create(queryString, 0, 0);
    }

    public void create(String queryString, int startAtIndex, int endAtIndex) throws QueryInvalidException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("create query for query-string: " + queryString);
        }
        if (endAtIndex != 0 && endAtIndex < startAtIndex) {
            throw new QueryInvalidException("endAtIndex must be greater than startAtIndex");
        }
        if (endAtIndex != 0 && startAtIndex != 0 && endAtIndex == startAtIndex) {
            throw new QueryInvalidException("endAtIndex cannot be set equal to startAtIndex");
        }
        try {
            StringReader reader = new StringReader(queryString);
            OQLLexer lexer = new OQLLexer(reader);
            OQLParser parser = new OQLParser(lexer);
            Query _query = parser.buildQuery();
            this.setBindIterator(this.flatten(_query.getCriteria(), new Vector()).listIterator());
            _query.setStartAtIndex(startAtIndex);
            _query.setEndAtIndex(endAtIndex);
            this.setQuery(_query);
        }
        catch (RecognitionException e) {
            throw new QueryInvalidException(e.getMessage());
        }
        catch (TokenStreamException e) {
            throw new QueryInvalidException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws QueryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start execute query");
        }
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        PBCapsule capsule = null;
        ManageableCollection result = null;
        try {
            capsule = new PBCapsule(this.pbKey, tx);
            PersistenceBroker broker = capsule.getBroker();
            if (!(this.query instanceof ReportQuery)) {
                result = broker.getCollectionByQuery(this.getCollectionClass(), this.query);
                this.performLockingIfRequired(tx, broker, result);
            } else {
                Iterator iter = null;
                result = new ManageableArrayList();
                iter = broker.getReportQueryIteratorByQuery(this.query);
                try {
                    block6: while (iter.hasNext()) {
                        Object[] res = (Object[])iter.next();
                        if (res.length == 1) {
                            if (res[0] == null) continue;
                            result.ojbAdd(res[0]);
                            continue;
                        }
                        for (int i = 0; i < res.length; ++i) {
                            if (res[i] == null) continue;
                            result.ojbAdd(res);
                            continue block6;
                        }
                    }
                }
                finally {
                    if (iter instanceof OJBIterator) {
                        ((OJBIterator)iter).releaseDbResources();
                    }
                }
            }
            ListIterator it = this.getBindIterator();
            while (it.hasPrevious()) {
                it.previous();
            }
        }
        finally {
            if (capsule != null) {
                capsule.destroy();
            }
        }
        return result;
    }

    protected void performLockingIfRequired(Transaction tx, PersistenceBroker broker, ManageableCollection result) {
        OdmgConfiguration config = this.getConfiguration();
        if (tx != null && config.useImplicitLocking()) {
            Iterator iter = result.ojbIterator();
            Object toBeLocked = null;
            Class<?> lastUsed = null;
            boolean didLockedLastUsed = false;
            while (iter.hasNext()) {
                toBeLocked = iter.next();
                Class<?> current = toBeLocked.getClass();
                if (current.equals(lastUsed) && didLockedLastUsed || broker.hasClassDescriptor(toBeLocked.getClass())) {
                    tx.lock(toBeLocked, 1);
                    lastUsed = current;
                    didLockedLastUsed = true;
                    continue;
                }
                lastUsed = current;
                didLockedLastUsed = false;
            }
        }
    }

    protected OdmgConfiguration getConfiguration() {
        OdmgConfiguration config = (OdmgConfiguration)((Object)PersistenceBrokerFactory.getConfigurator().getConfigurationFor(null));
        return config;
    }

    private void setQuery(Query query) {
        this.query = query;
    }

    protected ListIterator getBindIterator() {
        return this.bindIterator;
    }

    private void setBindIterator(ListIterator bindIterator) {
        this.bindIterator = bindIterator;
    }

    public void configure(Configuration pConfig) throws ConfigurationException {
        this.collectionClass = ((OdmgConfiguration)((Object)pConfig)).getOqlCollectionClass();
    }

    public int fullSize() {
        return this.query.fullSize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

