/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.lock.IsolationFactory;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.lock.ObjectLock;
import org.apache.ojb.otm.lock.isolation.TransactionIsolation;
import org.apache.ojb.otm.lock.map.LockMap;

public class LockManager {
    private static LockManager _Instance = new LockManager();

    public static LockManager getInstance() {
        return _Instance;
    }

    private LockManager() {
    }

    public void ensureLock(Identity oid, Transaction tx, int lock, PersistenceBroker pb) throws LockingException {
        LockMap lockMap = tx.getKit().getLockMap();
        ObjectLock objectLock = lockMap.getLock(oid);
        TransactionIsolation isolation = IsolationFactory.getIsolationLevel(pb, objectLock);
        if (lock == 1) {
            isolation.readLock(tx, objectLock);
        } else if (lock == 2) {
            isolation.writeLock(tx, objectLock);
        }
    }

    public int getLockHeld(Identity oid, Transaction tx) {
        LockMap lockMap = tx.getKit().getLockMap();
        ObjectLock lock = lockMap.getLock(oid);
        int lockHeld = 0;
        if (tx.equals(lock.getWriter())) {
            lockHeld = 2;
        } else if (lock.isReader(tx)) {
            lockHeld = 1;
        }
        return lockHeld;
    }

    public void releaseLock(Identity oid, Transaction tx) {
        LockMap lockMap = tx.getKit().getLockMap();
        ObjectLock objectLock = lockMap.getLock(oid);
        objectLock.releaseLock(tx);
    }
}

