/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.gnutella.GnutellaConnectionManager;
import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaDownloadService;
import com.echomine.gnutella.GnutellaListenerRouter;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaSearchService;
import com.echomine.gnutella.GnutellaShareService;
import com.echomine.gnutella.GnutellaStatistics;
import com.echomine.net.ConnectionModel;
import com.echomine.net.PerpetualSocketAcceptor;
import java.io.IOException;
import java.net.UnknownHostException;

public class Gnutella {
    protected GnutellaConnectionManager cmanager;
    protected GnutellaContext context;
    protected PerpetualSocketAcceptor listenerRouterAcceptor;
    protected GnutellaListenerRouter router;
    protected GnutellaDownloadService downloadService;
    protected GnutellaSearchService searchService;
    protected GnutellaShareService shareService;

    public Gnutella(GnutellaContext context) {
        this.context = context;
        this.router = new GnutellaListenerRouter();
        this.cmanager = new GnutellaConnectionManager(context, this.router);
        this.downloadService = new GnutellaDownloadService(context, this.cmanager, this.router);
        this.searchService = new GnutellaSearchService(context, this.cmanager, this.router);
        this.shareService = new GnutellaShareService(context, this.cmanager, this.router);
    }

    public void start() {
        this.cmanager.start();
        try {
            ConnectionModel model = this.context.getInterfaceIP() == null ? new ConnectionModel(this.context.getPort()) : new ConnectionModel(this.context.getInterfaceIP(), (int)this.context.getPort());
            this.listenerRouterAcceptor = new PerpetualSocketAcceptor(model);
            this.listenerRouterAcceptor.aaccept(this.router);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void connect(String IP, int port) throws UnknownHostException {
        this.cmanager.connect(IP, port);
    }

    public void connect(GnutellaConnectionModel model) throws UnknownHostException {
        this.cmanager.connect(model);
    }

    public void disconnect() {
        this.cmanager.disconnect();
        this.listenerRouterAcceptor.close();
    }

    public void send(GnutellaMessage msg) {
        this.cmanager.send(msg);
    }

    public GnutellaContext getContext() {
        return this.context;
    }

    public GnutellaConnectionManager getConnectionManager() {
        return this.cmanager;
    }

    public GnutellaDownloadService getDownloadService() {
        return this.downloadService;
    }

    public GnutellaSearchService getSearchService() {
        return this.searchService;
    }

    public GnutellaShareService getShareService() {
        return this.shareService;
    }

    public GnutellaListenerRouter getListenerRouter() {
        return this.router;
    }

    public GnutellaStatistics getStatistics() {
        return this.cmanager.getStatistics();
    }
}

