/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaListenerRouter;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageListener;
import com.echomine.gnutella.GnutellaMessageRouter;
import com.echomine.gnutella.GnutellaStatistics;
import com.echomine.gnutella.Host;
import com.echomine.gnutella.HostManager;
import com.echomine.gnutella.IConnectionList;
import com.echomine.gnutella.impl.ClientMessageRouter;
import com.echomine.gnutella.impl.ConnectionListImpl;
import com.echomine.gnutella.impl.GnutellaConnectorConnection;
import com.echomine.gnutella.impl.GnutellaStatisticsImpl;
import com.echomine.gnutella.impl.GnutellaV04RequestHandler;
import com.echomine.gnutella.impl.GnutellaV06RequestHandler;
import com.echomine.gnutella.impl.HostManagerImpl;
import com.echomine.net.Connection;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class GnutellaConnectionManager
extends Connection {
    GnutellaMessageRouter router;
    boolean connected;
    GnutellaContext context;
    ArrayList connectionThreads;
    GnutellaV04RequestHandler gnutellaV04Handler;
    GnutellaV06RequestHandler gnutellaV06Handler;
    IConnectionList connectionList;
    GnutellaConnectionQueue queue;
    HostManager hmanager;
    GnutellaStatistics stats;

    public GnutellaConnectionManager(GnutellaContext context, GnutellaListenerRouter listenerRouter) {
        this.context = context;
        this.connectionList = new ConnectionListImpl();
        this.stats = new GnutellaStatisticsImpl(this);
        this.router = new ClientMessageRouter(context, this.connectionList);
        this.queue = new GnutellaConnectionQueue();
        this.connectionThreads = new ArrayList(10);
        this.gnutellaV04Handler = new GnutellaV04RequestHandler(context, this.connectionList);
        this.gnutellaV06Handler = new GnutellaV06RequestHandler(context, this.connectionList);
        listenerRouter.addRequestHandler(this.gnutellaV04Handler);
        listenerRouter.addRequestHandler(this.gnutellaV06Handler);
        this.hmanager = new HostManagerImpl(this);
    }

    public synchronized void start() {
        this.connected = true;
        this.connectionList.start();
        this.createWorkers(this.getMaxOutgoingConnections());
    }

    public GnutellaConnectionModel connect(String server, int port) throws UnknownHostException {
        if (!this.connected) {
            return null;
        }
        GnutellaConnectionModel model = new GnutellaConnectionModel(server, port);
        this.connect(model);
        return model;
    }

    public void connect(GnutellaConnectionModel model) {
        if (!this.connected) {
            return;
        }
        this.queue.insert(model);
        this.createWorkers(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this;
        synchronized (object) {
            this.connected = false;
        }
        object = this.connectionThreads;
        synchronized (object) {
            int size = this.connectionThreads.size();
            for (int i = 0; i < size; ++i) {
                GnutellaConnectionWorker worker = (GnutellaConnectionWorker)this.connectionThreads.remove(0);
                worker.shutdown();
            }
        }
        this.connectionList.shutdown();
    }

    public GnutellaConnection disconnect(ConnectionModel model) {
        GnutellaConnection conn = this.connectionList.getActiveConnection(model);
        if (conn != null) {
            conn.disconnect();
        }
        return conn;
    }

    public void send(GnutellaMessage msg) {
        if (!this.connected) {
            return;
        }
        this.router.addToOwnMsg(msg);
        this.connectionList.sendMessageToAll(msg);
    }

    public GnutellaMessageRouter getMessageRouter() {
        return this.router;
    }

    public HostManager getHostManager() {
        return this.hmanager;
    }

    public GnutellaStatistics getStatistics() {
        return this.stats;
    }

    public int getEstablishedConnectionsCount() {
        return this.connectionList.getEstablishedConnectionsCount();
    }

    public int getActiveConnectionsCount() {
        return this.connectionList.getActiveConnectionsCount();
    }

    public List getActiveConnections() {
        return this.connectionList.getActiveConnections();
    }

    public List getEstablishedConnections() {
        return this.connectionList.getEstablishedConnections();
    }

    public GnutellaConnection getActiveConnection(ConnectionModel model) {
        return this.connectionList.getActiveConnection(model);
    }

    public GnutellaConnection getEstablishedConnection(ConnectionModel model) {
        return this.connectionList.getEstablishedConnection(model);
    }

    public void setMaxOutgoingConnections(int maxOutgoingConnections) {
        this.connectionList.setMaxOutgoingConnections(maxOutgoingConnections);
    }

    public int getMaxOutgoingConnections() {
        return this.connectionList.getMaxOutgoingConnections();
    }

    public void setMaxIncomingConnections(int maxIncomingConnections) {
        this.connectionList.setMaxIncomingConnections(maxIncomingConnections);
    }

    public int getMaxIncomingConnections() {
        return this.connectionList.getMaxIncomingConnections();
    }

    public void addConnectionListener(ConnectionListener l) {
        this.connectionList.addConnectionListener(l);
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.connectionList.removeConnectionListener(l);
    }

    public void addMessageListener(GnutellaMessageListener l) {
        this.connectionList.addMessageListener(l);
    }

    public void removeMessageListener(GnutellaMessageListener l) {
        this.connectionList.removeMessageListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createWorkers(int num) {
        if (!this.connected || num <= 0) {
            return;
        }
        ArrayList arrayList = this.connectionThreads;
        synchronized (arrayList) {
            for (int i = 0; i < num; ++i) {
                GnutellaConnectionWorker worker = new GnutellaConnectionWorker(this.queue);
                Thread thread = new Thread(worker);
                thread.start();
                this.connectionThreads.add(worker);
            }
        }
    }

    class GnutellaConnectionQueue {
        private LinkedList connections = new LinkedList();

        GnutellaConnectionQueue() {
        }

        public synchronized GnutellaConnectionModel waitForWork(long timeout) {
            if (this.connections.size() == 0) {
                if (GnutellaConnectionManager.this.connectionThreads.size() <= GnutellaConnectionManager.this.getMaxOutgoingConnections()) {
                    Host host = GnutellaConnectionManager.this.hmanager.next();
                    if (host != null) {
                        return new GnutellaConnectionModel(host.getHost(), host.getPort());
                    }
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException ex) {}
                } else {
                    return null;
                }
            }
            try {
                if (this.connections.size() > 0) {
                    return (GnutellaConnectionModel)this.connections.removeFirst();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        }

        public synchronized void add(GnutellaConnectionModel model) {
            this.connections.addLast(model);
            this.notify();
        }

        public synchronized void insert(GnutellaConnectionModel model) {
            this.connections.addFirst(model);
            this.notify();
        }

        public synchronized void clear() {
            this.connections.clear();
            this.notifyAll();
        }
    }

    class GnutellaConnectionWorker
    implements Runnable {
        private static final long IDLE_TIMEOUT = 5000L;
        private boolean shutdown;
        private GnutellaConnectionQueue queue;
        private GnutellaConnectorConnection connection;

        public GnutellaConnectionWorker(GnutellaConnectionQueue queue) {
            this.queue = queue;
            this.connection = new GnutellaConnectorConnection(GnutellaConnectionManager.this.context, 8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.shutdown = false;
            while (!this.shutdown) {
                GnutellaConnectionModel model = this.queue.waitForWork(5000L);
                if (model == null && GnutellaConnectionManager.this.connectionThreads.size() > GnutellaConnectionManager.this.connectionList.getMaxOutgoingConnections()) {
                    ArrayList arrayList = GnutellaConnectionManager.this.connectionThreads;
                    synchronized (arrayList) {
                        GnutellaConnectionManager.this.connectionThreads.remove(this);
                    }
                    this.shutdown = true;
                    break;
                }
                if (!this.shutdown && model != null) {
                    try {
                        if (!GnutellaConnectionManager.this.connectionList.addConnection(this.connection, model)) continue;
                        this.connection.connect(model);
                    }
                    catch (ConnectionFailedException connectionFailedException) {}
                    continue;
                }
                if (model == null) continue;
                this.queue.insert(model);
            }
        }

        public void shutdown() {
            this.shutdown = true;
            Thread.currentThread().interrupt();
            this.connection.disconnect();
        }

        public GnutellaConnection getConnection() {
            return this.connection;
        }
    }
}

