/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.gnutella.GUID;
import com.echomine.gnutella.GnutellaMessageFactory;
import com.echomine.gnutella.IRestrictedHostCallback;
import com.echomine.gnutella.ShareFileController;
import com.echomine.gnutella.impl.DefaultGnutellaMessageFactory;
import com.echomine.gnutella.impl.DefaultShareList;
import com.echomine.util.HTTPHeader;
import java.net.InetAddress;

public class GnutellaContext {
    private InetAddress interfaceIP;
    private short port = 0;
    private int lineSpeed = 0;
    protected GUID clientID = new GUID();
    private HTTPHeader supportedHeaders = new HTTPHeader();
    private HTTPHeader vendorHeaders = new HTTPHeader();
    private GnutellaMessageFactory messageFactory;
    private ShareFileController shareFileController;
    private IRestrictedHostCallback restrictedHostCallback;

    public GnutellaContext(short port, int lineSpeed) {
        this(null, port, lineSpeed);
    }

    public GnutellaContext(InetAddress interfaceIP, short port, int lineSpeed) {
        this.interfaceIP = interfaceIP;
        this.port = port;
        this.lineSpeed = lineSpeed;
        this.supportedHeaders.setHeader("User-Agent", "Echomine Muse");
    }

    public short getPort() {
        return this.port;
    }

    public void setPort(short port) {
        this.port = port;
    }

    public void setLineSpeed(int lineSpeed) {
        this.lineSpeed = lineSpeed;
    }

    public int getLineSpeed() {
        return this.lineSpeed;
    }

    public GUID getClientID() {
        return this.clientID;
    }

    public InetAddress getInterfaceIP() {
        return this.interfaceIP;
    }

    public void setIntefaceIP(InetAddress interfaceIP) {
        this.interfaceIP = interfaceIP;
    }

    public void setSupportedFeatureHeader(String headerName, String headerValue) {
        this.supportedHeaders.setHeader(headerName, headerValue);
    }

    public HTTPHeader getSupportedFeatureHeaders() {
        if (this.supportedHeaders.isEmpty()) {
            return null;
        }
        return this.supportedHeaders;
    }

    public void setVendorFeatureHeader(String headerName, String headerValue) {
        this.vendorHeaders.setHeader(headerName, headerValue);
    }

    public HTTPHeader getVendorFeatureHeaders() {
        if (this.vendorHeaders.isEmpty()) {
            return null;
        }
        return this.vendorHeaders;
    }

    public GnutellaMessageFactory getMessageFactory() {
        if (this.messageFactory == null) {
            this.messageFactory = new DefaultGnutellaMessageFactory();
        }
        return this.messageFactory;
    }

    public void setMessageFactory(GnutellaMessageFactory factory) {
        this.messageFactory = factory;
    }

    public ShareFileController getShareFileController() {
        if (this.shareFileController == null) {
            this.shareFileController = new DefaultShareList();
        }
        return this.shareFileController;
    }

    public void setShareFileController(ShareFileController shareFileController) {
        this.shareFileController = shareFileController;
    }

    public void setRestrictedHostCallback(IRestrictedHostCallback callback) {
        this.restrictedHostCallback = callback;
    }

    public IRestrictedHostCallback getRestrictedHostCallback() {
        return this.restrictedHostCallback;
    }
}

