/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.gnutella.ListenerRequestHandler;
import com.echomine.net.SocketHandler;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class GnutellaListenerRouter
implements SocketHandler {
    protected static final byte[] INVALID_REQUEST = "HTTP 503 INVALID REQUEST".getBytes();
    protected static final byte[] REQUEST_NOT_SUPPORTED = "HTTP 503 REQUEST NOT SUPPORTED".getBytes();
    protected static final int SOCKETBUF = 1024;
    private Vector requestHandlers = new Vector(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Socket socket) throws IOException {
        OutputStream os;
        InputStream is;
        block6: {
            int bytesread;
            byte[] bytebuf;
            block5: {
                is = null;
                os = null;
                socket.setSoTimeout(1000);
                os = socket.getOutputStream();
                is = socket.getInputStream();
                bytebuf = new byte[1024];
                bytesread = IOUtil.readToCRLF(is, bytebuf, 0, 1024);
                if (bytesread > 0) break block5;
                os.write(INVALID_REQUEST);
                IOUtil.closeStream(os);
                IOUtil.closeStream(is);
                return;
            }
            try {
                String request = new String(bytebuf, 0, bytesread);
                int size = this.requestHandlers.size();
                ListenerRequestHandler listener = null;
                boolean handlerFound = false;
                for (int i = 0; i < size; ++i) {
                    listener = (ListenerRequestHandler)this.requestHandlers.get(i);
                    if (!listener.canHandle(request)) continue;
                    handlerFound = true;
                    break;
                }
                if (handlerFound) {
                    socket.setSoTimeout(0);
                    listener.handleRequest(request, socket);
                    break block6;
                }
                os.write(REQUEST_NOT_SUPPORTED);
            }
            catch (Throwable throwable) {
                IOUtil.closeStream(os);
                IOUtil.closeStream(is);
                throw throwable;
            }
        }
        IOUtil.closeStream(os);
        IOUtil.closeStream(is);
    }

    public void shutdown() {
    }

    public void start() {
    }

    public void addRequestHandler(ListenerRequestHandler handler) {
        this.requestHandlers.add(handler);
    }

    public void removeRequestHandler(ListenerRequestHandler handler) {
        this.requestHandlers.remove(handler);
    }
}

