/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.MessageRouterController;

public abstract class GnutellaMessage {
    protected GnutellaMessageHeader header;

    public GnutellaMessage(GnutellaMessageHeader header) {
        this.header = header;
    }

    public int getType() {
        return this.header.getFunction();
    }

    public boolean decTTL() {
        GnutellaMessageHeader header = this.getHeader();
        int ttl = header.getTTL() - 1;
        if (ttl <= 0) {
            return true;
        }
        if (ttl > 7) {
            ttl = 7;
        }
        header.setTTL(ttl);
        header.setHopsTaken(header.getHopsTaken() + 1);
        return false;
    }

    public void setHeader(GnutellaMessageHeader header) {
        this.header = header;
    }

    public GnutellaMessageHeader getHeader() {
        return this.header;
    }

    public byte[] serialize() throws ParseException {
        this.computeDataLen();
        int lenToSend = this.getSize();
        byte[] buf = new byte[lenToSend];
        this.serialize(buf, 0);
        return buf;
    }

    public int serialize(byte[] outbuf, int offset) throws ParseException {
        return this.header.serialize(outbuf, offset);
    }

    public int deserialize(byte[] inbuf, int offset, int length) throws ParseException {
        return offset;
    }

    public int getSize() {
        return this.header.getSize();
    }

    public void copy(GnutellaMessage b) {
        this.header.copy(b.getHeader());
    }

    public void computeDataLen() {
        this.header.setDataLen(this.getSize() - this.header.getSize());
    }

    public String toString() {
        return "[" + this.header + "]";
    }

    public abstract void route(GnutellaConnection var1, MessageRouterController var2);
}

