/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GUID;
import com.echomine.util.ParseUtil;

public class GnutellaMessageHeader {
    public static final int sDataLength = 23;
    private GUID mMsgID;
    private int mFunction;
    private int mTTL;
    private int mHopsTaken;
    private int mDataLen;
    private long mArrivalTime;

    public GnutellaMessageHeader() {
        this(255, new GUID(false));
    }

    public GnutellaMessageHeader(int msgtype) {
        this(msgtype, new GUID());
    }

    public GnutellaMessageHeader(int msgtype, GUID guid) {
        this.mMsgID = guid;
        this.mFunction = msgtype;
        this.mTTL = 7;
        this.mHopsTaken = 0;
        this.mDataLen = 0;
    }

    public GUID getMsgID() {
        return this.mMsgID;
    }

    public void setMsgID(GUID MsgID) {
        this.mMsgID = MsgID;
    }

    public int getFunction() {
        return this.mFunction;
    }

    public void setFunction(int Function2) {
        this.mFunction = Function2;
    }

    public String getFunctionName() {
        switch (this.mFunction) {
            case 0: {
                return "Init";
            }
            case 1: {
                return "InitResponse";
            }
            case 64: {
                return "PushRequest";
            }
            case 128: {
                return "Query";
            }
            case 129: {
                return "QueryResponse";
            }
        }
        return "Unknown";
    }

    public int getTTL() {
        return this.mTTL;
    }

    public void setTTL(int TTL) {
        this.mTTL = TTL;
    }

    public int getHopsTaken() {
        return this.mHopsTaken;
    }

    public void setHopsTaken(int HopsTaken) {
        this.mHopsTaken = HopsTaken;
    }

    public int getDataLen() {
        return this.mDataLen;
    }

    public void setDataLen(int DataLen) {
        this.mDataLen = DataLen;
    }

    public long getArrivalTime() {
        return this.mArrivalTime;
    }

    public void setArrivalTime(long arrivalTime) {
        this.mArrivalTime = arrivalTime;
    }

    public int getSize() {
        return 23;
    }

    public void copy(GnutellaMessageHeader b) {
        this.mMsgID = b.mMsgID;
        this.mFunction = b.mFunction;
        this.mTTL = b.mTTL;
        this.mHopsTaken = b.mHopsTaken;
        this.mDataLen = b.mDataLen;
    }

    public int serialize(byte[] outbuf, int offset) throws ParseException {
        offset = this.mMsgID.serialize(outbuf, offset);
        outbuf[offset++] = (byte)this.mFunction;
        outbuf[offset++] = (byte)this.mTTL;
        outbuf[offset++] = (byte)this.mHopsTaken;
        offset = ParseUtil.serializeIntLE(this.mDataLen, outbuf, offset);
        return offset;
    }

    public int deserialize(byte[] inbuf, int offset) throws ParseException {
        offset = this.mMsgID.deserialize(inbuf, offset);
        this.mFunction = inbuf[offset++];
        this.mFunction = this.mFunction < 0 ? this.mFunction + 256 : this.mFunction;
        this.mTTL = inbuf[offset++];
        this.mTTL = this.mTTL < 0 ? this.mTTL + 256 : this.mTTL;
        this.mHopsTaken = inbuf[offset++];
        this.mHopsTaken = this.mHopsTaken < 0 ? this.mHopsTaken + 256 : this.mHopsTaken;
        this.mDataLen = ParseUtil.deserializeIntLE(inbuf, offset);
        if (this.mDataLen < 0) {
            this.mDataLen = 0;
        }
        return offset += 4;
    }

    public String toString() {
        return "[MsgID=" + this.mMsgID + ", " + "Function=" + this.mFunction + "(" + this.getFunctionName() + "), " + "TTL=" + this.mTTL + ", " + "HopsTaken=" + this.mHopsTaken + ", " + "DataLen=" + this.mDataLen + "]";
    }
}

